/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import io.agistep.event.Event;
import io.agistep.event.EventHandler;
import io.agistep.utils.AnnotationHelper;
import io.agistep.utils.MethodInvokeHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.tuple.Pair;
import org.valid4j.Validation;

class EventHandlerMethodAdapter {
    private final String aggregateName;
    private final Pair<EventHandler, Method> handlerMethodPair;

    EventHandlerMethodAdapter(Class<?> aggregateClass, Pair<EventHandler, Method> handlerMethodPair) {
        this.aggregateName = aggregateClass.getName();
        this.handlerMethodPair = handlerMethodPair;
    }

    public static EventHandlerMethodAdapter init(Method method) {
        Validation.validate((method != null ? 1 : 0) != 0, (Exception)new IllegalArgumentException("Method is null"));
        EventHandler annotation = AnnotationHelper.getAnnotation(method, EventHandler.class);
        Validation.validate((annotation != null ? 1 : 0) != 0, (Exception)new IllegalArgumentException("EventHandler annotation is not present on method: " + method.getName()));
        Pair eventHandlerMethodPair = Pair.of((Object)annotation, (Object)method);
        return new EventHandlerMethodAdapter(method.getDeclaringClass(), (Pair<EventHandler, Method>)eventHandlerMethodPair);
    }

    String getAggregateName() {
        return this.aggregateName;
    }

    public void handle(Object aggregate, Event anEvent) {
        try {
            Method method = (Method)this.handlerMethodPair.getValue();
            method.setAccessible(true);
            MethodInvokeHelper.invoke(aggregate, anEvent, method);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    String getPayloadName() {
        return ((EventHandler)this.handlerMethodPair.getKey()).payload().getName();
    }
}

