/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.utils;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public final class ScanClassProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<Class<?>> scanAllClassesIn(String packageName) {
        HashSet classes = new HashSet();
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().acceptPackages(new String[]{packageName}).scan();){
            for (ClassInfo classInfo : scanResult.getAllClasses()) {
                try {
                    classes.add(Class.forName(classInfo.getName()));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Failed to load class: " + classInfo.getName(), e);
                    return classes;
                }
            }
        }
    }

    public static Set<Class<?>> scanAndGetAllClasses2(String packageName) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        HashSet<File> dirs = new HashSet<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        HashSet classes = new HashSet();
        for (File directory : dirs) {
            classes.addAll(ScanClassProvider.findClasses(directory, packageName));
        }
        return classes;
    }

    private static Set<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        HashSet classes = new HashSet();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(ScanClassProvider.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + "." + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }
}

