/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import io.agistep.aggregator.IdUtils;
import java.util.HashMap;
import java.util.Map;

class ThreadLocalEventSeqHolder {
    private static final ThreadLocal<Map<Long, Long>> changes = ThreadLocal.withInitial(HashMap::new);

    public static ThreadLocalEventSeqHolder instance() {
        return new ThreadLocalEventSeqHolder();
    }

    private ThreadLocalEventSeqHolder() {
    }

    public void setSeq(long aggregateId, long seq) {
        changes.get().put(aggregateId, seq);
    }

    public void clearAll() {
        changes.remove();
    }

    public void clear(Object aggregate) {
        long id = IdUtils.idOf(aggregate);
        changes.get().remove(id);
    }

    long nextSeq(Long aggregateId) {
        return this.getSeq(aggregateId) + 1L;
    }

    long getSeq(Long aggregateId) {
        return changes.get().getOrDefault(aggregateId, -1L);
    }
}

