/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import io.agistep.aggregator.IdUtils;
import io.agistep.event.Event;
import io.agistep.event.EventApplier;
import io.agistep.event.EventReplayer;
import io.agistep.event.HoldListener;
import io.agistep.event.Listener;
import io.agistep.event.ReplayListener;
import io.agistep.event.ThreadLocalEventHolder;
import io.agistep.event.ThreadLocalEventSeqHolder;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.valid4j.Assertive;

public final class EventSource {
    public static final long INITIAL_SEQ = 0L;
    public static HoldListener holdListener;
    public static ReplayListener replayListener;

    private EventSource() {
    }

    public static void apply(Object aggregate, Object payload) {
        EventApplier.apply(aggregate, payload);
    }

    public static List<Event> getHoldEvents(Object aggregate) {
        return ThreadLocalEventHolder.instance().getEvents(aggregate);
    }

    public static long getLatestSeqOf(Object aggregate) {
        return EventSource.getLatestSeqOf(IdUtils.idOf(aggregate));
    }

    public static long getLatestSeqOf(Long aggregateId) {
        return ThreadLocalEventSeqHolder.instance().getSeq(aggregateId);
    }

    public static void replay(Object aggregate, Event anEvent) {
        EventReplayer.replay(aggregate, anEvent);
    }

    public static void replay(Object aggregate, Event[] events) {
        Arrays.stream(events).forEach(e -> EventSource.replay(aggregate, e));
    }

    public static void clearAll() {
        ThreadLocalEventHolder.instance().clearAll();
    }

    public static void clear(Object aggregate) {
        ThreadLocalEventHolder.instance().clear(aggregate);
    }

    public static void setListener(Listener listener) {
        EventSource.setListener((HoldListener)listener);
        EventSource.setListener((ReplayListener)listener);
    }

    public static void setListener(HoldListener holdListener) {
        EventSource.holdListener = holdListener;
    }

    public static void setListener(ReplayListener replayListener) {
        EventSource.replayListener = replayListener;
    }

    private static class ObjectPayloadEnvelop
    implements Event {
        private final long id;
        private final String name;
        private final long seq;
        private final Long aggregateId;
        private final Object payload;
        private final LocalDateTime occurredAt;

        private ObjectPayloadEnvelop(long id, String name, long seq, Long aggregateId, Object payload, LocalDateTime occurredAt) {
            this.id = id;
            this.name = name;
            this.seq = seq;
            this.aggregateId = aggregateId;
            this.payload = payload;
            this.occurredAt = occurredAt;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getSeq() {
            return this.seq;
        }

        @Override
        public long getAggregateId() {
            return this.aggregateId;
        }

        @Override
        public Object getPayload() {
            return this.payload;
        }

        @Override
        public LocalDateTime getOccurredAt() {
            return this.occurredAt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectPayloadEnvelop that = (ObjectPayloadEnvelop)o;
            return this.seq == that.seq && Objects.equals(this.aggregateId, that.aggregateId) && Objects.equals(this.name, that.name) && Objects.equals(this.payload, that.payload) && Objects.equals(this.occurredAt, that.occurredAt);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.seq, this.aggregateId, this.payload, this.occurredAt);
        }

        public String toString() {
            return "ObjectPayloadEnvelop{id=" + this.id + ", name='" + this.name + "', seq=" + this.seq + ", aggregateId=" + this.aggregateId + ", payload=" + this.payload + ", occurredAt=" + this.occurredAt + "}";
        }
    }

    public static final class EventBuilder {
        private Long id;
        private String name;
        private Long seq;
        private Long aggregateId;
        private Object payload;
        private LocalDateTime occurredAt;

        private EventBuilder() {
        }

        public Event build() {
            if (this.occurredAt == null) {
                this.occurredAt(LocalDateTime.now());
            }
            String n = this.payload.getClass().getName();
            return new ObjectPayloadEnvelop((Long)Assertive.require((Object)this.id, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()))), n, this.seq, this.aggregateId, this.payload, this.occurredAt);
        }

        public EventBuilder id(long id) {
            this.id = id;
            return this;
        }

        public EventBuilder seq(long seq) {
            this.seq = seq;
            return this;
        }

        public EventBuilder aggregateId(Long aggregateId) {
            this.aggregateId = aggregateId;
            return this;
        }

        public EventBuilder payload(Object payload) {
            this.payload = payload;
            return this;
        }

        public EventBuilder occurredAt(LocalDateTime occurredAt) {
            this.occurredAt = occurredAt;
            return this;
        }
    }
}

