/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import io.agistep.event.Event;
import io.agistep.event.EventMaker;
import io.agistep.event.EventReplayer;
import io.agistep.event.EventSource;
import io.agistep.event.ReplayListener;
import io.agistep.event.ThreadLocalEventHolder;
import java.util.Optional;

final class EventApplier {
    static final ReplayListener DUMMY = new ReplayListener(){

        @Override
        public void beforeReplay(Object aggregate, Event event) {
        }

        @Override
        public void afterReplay(Object aggregate, Event event) {
        }
    };

    EventApplier() {
    }

    static void apply(Object aggregate, Object payload) {
        Event anEvent = EventMaker.make(aggregate, payload);
        EventApplier.replay(aggregate, anEvent);
        EventApplier.hold(anEvent);
    }

    private static void hold(Event anEvent) {
        Optional.ofNullable(EventSource.holdListener).ifPresent(listen -> listen.beforeHold(anEvent));
        ThreadLocalEventHolder.instance().hold(anEvent);
        Optional.ofNullable(EventSource.holdListener).ifPresent(listen -> listen.afterHold(anEvent));
    }

    private static void replay(Object aggregate, Event anEvent) {
        Optional.ofNullable(EventSource.replayListener).ifPresent(listen -> listen.beforeReplay(aggregate, anEvent));
        EventReplayer.replay(aggregate, anEvent);
        Optional.ofNullable(EventSource.replayListener).ifPresent(listen -> listen.afterReplay(aggregate, anEvent));
    }
}

