/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import java.util.HashMap;
import java.util.Map;

class ThreadLocalEventSeqHolder {
    private static final ThreadLocal<Map<Long, Long>> changes = ThreadLocal.withInitial(HashMap::new);

    public static ThreadLocalEventSeqHolder instance() {
        return new ThreadLocalEventSeqHolder();
    }

    private ThreadLocalEventSeqHolder() {
    }

    public void setSeq(long aggregateId, long seq) {
        changes.get().put(aggregateId, seq);
    }

    public void clearAll() {
        changes.remove();
    }

    public void clear(Object aggregate) {
        changes.remove();
    }

    long nextVersion(Long aggregateId) {
        return this.getVersion(aggregateId) + 1L;
    }

    long getVersion(Long aggregateId) {
        return changes.get().getOrDefault(aggregateId, -1L);
    }
}

