/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import io.agistep.event.Event;
import io.agistep.event.EventHandler;
import io.agistep.event.HandlerAdapter;
import io.agistep.event.ThreadLocalEventSeqHolder;
import io.agistep.utils.AnnotationHelper;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

final class EventReorganizer {
    static final Map<String, HandlerAdapter> handlers = new HashMap<String, HandlerAdapter>();

    EventReorganizer() {
    }

    static void reorganize(Object aggregate, Event anEvent) {
        HandlerAdapter handler = EventReorganizer.findHandler(aggregate);
        handler.handle(aggregate, anEvent);
        EventReorganizer.updateSeq(anEvent.getAggregateId(), anEvent.getSeq());
    }

    private static HandlerAdapter findHandler(Object aggregate) {
        String aggregateName = aggregate.getClass().getName();
        HandlerAdapter handler = EventReorganizer.retrieveHandler(aggregateName);
        if (handler != null) {
            return handler;
        }
        return EventReorganizer.caching(EventReorganizer.initHandler(aggregate));
    }

    private static HandlerAdapter initHandler(Object aggregate) {
        String aggregateName = aggregate.getClass().getName();
        List<Method> eventHandlerMethods = AnnotationHelper.getMethodsListWithAnnotation(aggregate.getClass(), EventHandler.class);
        List<Pair<EventHandler, Method>> aa = eventHandlerMethods.stream().map(m -> {
            EventHandler annotation = AnnotationHelper.getAnnotation(m, EventHandler.class);
            return Pair.of((Object)annotation, (Object)m);
        }).collect(Collectors.toList());
        return new HandlerAdapter(aggregateName, aa);
    }

    private static HandlerAdapter retrieveHandler(String aggregateName) {
        return handlers.get(aggregateName);
    }

    private static HandlerAdapter caching(HandlerAdapter handler) {
        handlers.put(handler.getAggregateName(), handler);
        return handler;
    }

    private static void updateSeq(long aggregateId, long seq) {
        ThreadLocalEventSeqHolder.instance().setSeq(aggregateId, seq);
    }
}

