/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import io.agistep.aggregator.IdUtils;
import io.agistep.event.Event;
import io.agistep.event.EventReorganizer;
import io.agistep.event.Events;
import io.agistep.event.ReorganizeListener;
import io.agistep.event.ThreadLocalEventHolder;
import io.agistep.event.ThreadLocalEventSeqHolder;
import java.time.LocalDateTime;
import java.util.Optional;

final class EventApplier {
    static final ReorganizeListener DUMMY = new ReorganizeListener(){

        @Override
        public void beforeReorganize(Object aggregate, Event event) {
        }

        @Override
        public void afterReorganize(Object aggregate, Event event) {
        }
    };

    EventApplier() {
    }

    static void apply(Object aggregate, Object payload) {
        Event anEvent = EventApplier.make(aggregate, payload);
        EventApplier.reorganize(aggregate, anEvent);
        EventApplier.hold(anEvent);
    }

    private static Event make(Object aggregate, Object payload) {
        long nextVersion;
        long aggregateId;
        long eventId = IdUtils.gen();
        if (IdUtils.notAssignedIdOf(aggregate)) {
            aggregateId = IdUtils.gen();
            nextVersion = 0L;
        } else {
            aggregateId = IdUtils.idOf(aggregate);
            nextVersion = EventApplier.nextVersion(aggregateId);
        }
        return Events.builder().id(eventId).aggregateId(aggregateId).seq(nextVersion).name(payload.getClass().getName()).payload(payload).occurredAt(LocalDateTime.now()).build();
    }

    private static void hold(Event anEvent) {
        Optional.ofNullable(Events.holdListener).ifPresent(listen -> listen.beforeHold(anEvent));
        ThreadLocalEventHolder.instance().hold(anEvent);
        Optional.ofNullable(Events.holdListener).ifPresent(listen -> listen.afterHold(anEvent));
    }

    private static void reorganize(Object aggregate, Event anEvent) {
        Optional.ofNullable(Events.reorganizeListener).ifPresent(listen -> listen.beforeReorganize(aggregate, anEvent));
        EventReorganizer.reorganize(aggregate, anEvent);
        Optional.ofNullable(Events.reorganizeListener).ifPresent(listen -> listen.afterReorganize(aggregate, anEvent));
    }

    private static long nextVersion(Object aggregateId) {
        return ThreadLocalEventSeqHolder.instance().nextVersion((Long)aggregateId);
    }
}

