/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import io.agistep.event.Event;
import io.agistep.event.EventHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

class HandlerAdapter {
    private final String aggregateName;
    private final List<Pair<EventHandler, Method>> handlerMethods;

    public HandlerAdapter(String aggregateName, List<Pair<EventHandler, Method>> handlerMethods) {
        this.aggregateName = aggregateName;
        this.handlerMethods = handlerMethods;
    }

    String getAggregateName() {
        return this.aggregateName;
    }

    public void handle(Object aggregate, Event anEvent) {
        String eventName = anEvent.getName();
        Pair aa = this.handlerMethods.stream().filter(hm -> ((EventHandler)hm.getKey()).payload().getName().equals(eventName)).findFirst().get();
        try {
            Method method = (Method)aa.getValue();
            method.setAccessible(true);
            method.invoke(aggregate, anEvent);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

