/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event.sed;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.agistep.event.Event;
import io.agistep.event.ObjectPayloadEnvelop;
import io.agistep.event.sed.JsonSerializer;
import io.agistep.event.sed.ProtocolBufferDeserializer;
import io.agistep.event.sed.ProtocolBufferSerializer;
import io.agistep.event.sed.Serializer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ConvertUtil {
    public static String convert(Event e) {
        return EventToJson.convert(e);
    }

    public static Event convert(String str) {
        return JsonToEvent.convert(str);
    }

    static final class EventToJson {
        EventToJson() {
        }

        public static String convert(Event e) {
            try {
                EventDTO eventDTO = new EventDTO();
                eventDTO.setId(e.getId());
                eventDTO.setName(e.getName());
                eventDTO.setVersion(e.getVersion());
                eventDTO.setAggregateId(e.getAggregateId());
                eventDTO.setOccurredAt(e.getOccurredAt().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
                Object payload = e.getPayload();
                List<ProtocolBufferSerializer> serializers = List.of(new JsonSerializer(), new ProtocolBufferSerializer());
                Serializer serializer = serializers.stream().filter(s -> s.isSupport(payload)).findFirst().orElseThrow(UnsupportedOperationException::new);
                eventDTO.setPayload(new String(serializer.serialize(payload)));
                ObjectMapper om = new ObjectMapper();
                om.registerModule((Module)new JavaTimeModule());
                return om.writeValueAsString((Object)eventDTO);
            }
            catch (JsonProcessingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static final class JsonToEvent {
        JsonToEvent() {
        }

        public static Event convert(String str) {
            ObjectMapper om = new ObjectMapper();
            try {
                EventDTO eventDTO = (EventDTO)om.readValue(str, EventDTO.class);
                Class<?> clazz = Class.forName(eventDTO.getName());
                ProtocolBufferDeserializer deserialize = new ProtocolBufferDeserializer(clazz);
                Object payload = deserialize.deserialize(eventDTO.getPayload().getBytes());
                LocalDateTime occurredAt = LocalDateTime.parse(eventDTO.getOccurredAt(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                return new ObjectPayloadEnvelop(eventDTO.getId(), eventDTO.getName(), eventDTO.getVersion(), eventDTO.getAggregateId(), payload, occurredAt);
            }
            catch (JsonProcessingException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class EventDTO {
        long id;
        long version;
        String name;
        long aggregateId;
        String payload;
        String occurredAt;

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public long getVersion() {
            return this.version;
        }

        public void setVersion(long version) {
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getAggregateId() {
            return this.aggregateId;
        }

        public void setAggregateId(long aggregateId) {
            this.aggregateId = aggregateId;
        }

        public String getPayload() {
            return this.payload;
        }

        public void setPayload(String payload) {
            this.payload = payload;
        }

        public String getOccurredAt() {
            return this.occurredAt;
        }

        public void setOccurredAt(String occurredAt) {
            this.occurredAt = occurredAt;
        }
    }
}

