/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import io.agistep.event.AggregateIdUtils;
import io.agistep.event.Event;
import io.agistep.identity.IdentityValueProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ThreadLocalEventVersionHolder {
    public static final long BEGIN_VERSION = 0L;
    private static final ThreadLocal<Map<Long, Long>> changes = new ThreadLocal();

    public static ThreadLocalEventVersionHolder instance() {
        return new ThreadLocalEventVersionHolder();
    }

    private ThreadLocalEventVersionHolder() {
    }

    public void setVersion(Object aggregate, Event anEvent) {
        Long aggregateId = AggregateIdUtils.getIdFrom(aggregate);
        if (this.isNotInit(aggregateId)) {
            this.init(aggregate);
        }
        long version = anEvent.getVersion();
        if (Objects.isNull(changes.get())) {
            changes.set(new HashMap());
        }
        changes.get().put(aggregateId, version);
    }

    private void init(Object aggregate) {
        Long aggregateId = AggregateIdUtils.getIdFrom(aggregate);
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        map.put(aggregateId, 0L);
        changes.set(map);
    }

    private boolean isNotInit(Long aggregateId) {
        if (Objects.isNull(changes.get())) {
            return true;
        }
        return Optional.ofNullable(changes.get().get(aggregateId)).isEmpty();
    }

    public Long setVersion(Object aggregate) {
        long aggregateIdValue;
        if (Objects.isNull(changes.get())) {
            changes.set(new HashMap());
        }
        long l = aggregateIdValue = AggregateIdUtils.getIdFrom(aggregate) == -1L ? IdentityValueProvider.instance().newLong() : AggregateIdUtils.getIdFrom(aggregate);
        if (!changes.get().containsKey(aggregateIdValue)) {
            changes.get().put(aggregateIdValue, 0L);
        } else {
            changes.get().put(aggregateIdValue, changes.get().get(aggregateIdValue) + 1L);
        }
        return changes.get().get(aggregateIdValue);
    }

    public void clearAll() {
        changes.remove();
    }

    public void clear(Object aggregate) {
        changes.remove();
    }
}

