/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import io.agistep.event.AggregateIdUtils;
import io.agistep.event.Event;
import io.agistep.event.EventHolder;
import io.agistep.event.ThreadLocalEventVersionHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class ThreadLocalEventHolder
implements EventHolder {
    private static final ThreadLocal<List<Event>> changes = new ThreadLocal();

    static EventHolder instance() {
        return new ThreadLocalEventHolder();
    }

    private ThreadLocalEventHolder() {
    }

    @Override
    public List<Event> getEventAll() {
        return ThreadLocalEventHolder.isEmpty(changes.get()) ? List.of() : Collections.unmodifiableList(changes.get());
    }

    @Override
    public void occurs(Event anEvent) {
        List<Event> events = changes.get();
        if (ThreadLocalEventHolder.isEmpty(events)) {
            events = ThreadLocalEventHolder.init();
        }
        events.add(anEvent);
    }

    private static List<Event> init() {
        changes.set(Collections.synchronizedList(new ArrayList()));
        return changes.get();
    }

    private static boolean isEmpty(List<Event> events) {
        return events == null || events.isEmpty();
    }

    @Override
    public List<Event> getEvents(Object aggregate) {
        long idValue = AggregateIdUtils.getIdFrom(aggregate);
        return this.getEventAll().stream().filter(e -> Objects.equals(idValue, e.getAggregateId())).collect(Collectors.toList());
    }

    @Override
    public void clearAll() {
        changes.remove();
        ThreadLocalEventVersionHolder.instance().clearAll();
    }

    @Override
    public void clear(Object aggregate) {
        long id = AggregateIdUtils.getIdFrom(aggregate);
        List events = changes.get().stream().filter(e -> e.getAggregateId() == id).collect(Collectors.toList());
        List remained = changes.get().stream().filter(e -> !events.contains(e)).collect(Collectors.toList());
        changes.set(remained);
        ThreadLocalEventVersionHolder.instance().clear(aggregate);
    }
}

