/*
 * Decompiled with CFR 0.152.
 */
package io.agistep.event;

import io.agistep.event.Event;
import io.agistep.event.EventHandler;
import io.agistep.event.HandlerAdapter;
import io.agistep.event.ThreadLocalEventVersionHolder;
import io.agistep.utils.AnnotationHelper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public final class EventReorganizor {
    static final Map<String, HandlerAdapter> handlers = new HashMap<String, HandlerAdapter>();

    public static void reorganize(Object aggregate, Event[] events) {
        Arrays.stream(events).forEach(e -> EventReorganizor.reorganize(aggregate, e));
    }

    public static void reorganize(Object aggregate, Event anEvent) {
        HandlerAdapter handler = EventReorganizor.findHandler(aggregate);
        handler.handle(aggregate, anEvent);
        ThreadLocalEventVersionHolder.instance().setVersion(aggregate, anEvent);
    }

    private static HandlerAdapter findHandler(Object aggregate) {
        String aggregateName = aggregate.getClass().getName();
        HandlerAdapter handler = EventReorganizor.retrieveHandler(aggregateName);
        if (handler != null) {
            return handler;
        }
        return EventReorganizor.caching(EventReorganizor.initHandler(aggregate));
    }

    private static HandlerAdapter initHandler(Object aggregate) {
        String aggregateName = aggregate.getClass().getName();
        List<Method> eventHandlerMethods = AnnotationHelper.getMethodsListWithAnnotation(aggregate.getClass(), EventHandler.class);
        List<Pair<EventHandler, Method>> aa = eventHandlerMethods.stream().map(m -> {
            EventHandler annotation = AnnotationHelper.getAnnotation(m, EventHandler.class);
            return Pair.of((Object)annotation, (Object)m);
        }).collect(Collectors.toList());
        return new HandlerAdapter(aggregateName, aa);
    }

    private static HandlerAdapter retrieveHandler(String aggregateName) {
        return handlers.get(aggregateName);
    }

    private static HandlerAdapter caching(HandlerAdapter handler) {
        handlers.put(handler.getAggregateName(), handler);
        return handler;
    }
}

