/*
 * Decompiled with CFR 0.152.
 */
package io.afu.common.component;

import io.afu.common.exception.BaseException;

public class AssertHelper {
    public static void NotNull(Object obj, String msg) throws BaseException {
        if (obj == null) {
            throw new BaseException(msg);
        }
    }

    public static void FeildNotNull(Object obj, String feild, String msg) throws BaseException {
        try {
            if (obj.getClass().getDeclaredField(feild).get(obj) == null) {
                throw new BaseException(msg);
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new BaseException("\u9700\u8981\u7a7a\u5224\u7684\u5bf9\u8c61\u5c5e\u6027\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            throw new BaseException(msg);
        }
    }

    public static <T> void OnlyContains(T[] arr, T target, String msg) throws BaseException {
        AssertHelper.OnlyContains(arr, target, msg, false);
    }

    public static <T> void OnlyContains(T[] arr, T target, String msg, boolean allowNull) throws BaseException {
        if (!allowNull) {
            AssertHelper.NotNull(target, msg);
        } else if (target == null) {
            return;
        }
        boolean flag = false;
        for (T t : arr) {
            if (!t.equals(target)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            throw new BaseException(msg);
        }
    }

    public static <T> void FieldOnlyContains(Object obj, String feild, T[] values, String msg) throws BaseException {
        try {
            Object value = obj.getClass().getDeclaredField(feild).get(obj);
            for (T v : values) {
                if (!v.equals(value)) continue;
                return;
            }
            throw new BaseException(msg);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new BaseException("\u9700\u8981\u7a7a\u5224\u7684\u5bf9\u8c61\u5c5e\u6027\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            throw new BaseException(msg);
        }
    }

    public static void MaxNumber(Integer number, Integer max, String msg) throws BaseException {
        AssertHelper.NotNull(number, msg);
        if (number > max) {
            throw new BaseException(msg);
        }
    }

    public static void MinNumber(Integer number, Integer min, String msg) throws BaseException {
        AssertHelper.NotNull(number, msg);
        if (number < min) {
            throw new BaseException(msg);
        }
    }
}

