package io.afu.common.dto;


import io.afu.common.constant.ConstantEnum;
import io.afu.common.exception.BaseException;

import java.util.List;

/**
 * @author RffanLAB.方露宇
 */
public class BaseRespDto<T> {
    private Boolean status;
    private Integer code;
    private String msg;
    private T data;


    public Boolean getStatus() {
        return status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setTrue(){
        this.status = true;
        this.code = ConstantEnum.OPERATION_SUCCESS.getCode();
    }

    public void setFalse(){
        this.status = false;
        this.code = ConstantEnum.OPERATION_FAILED.getCode();
    }

    public void setTrueMsg(String msg){
        this.status = true;
        this.code = ConstantEnum.OPERATION_SUCCESS.getCode();
        this.msg = msg;
    }

    public void setErrorMsg(String msg){
        this.status = false;
        this.code = ConstantEnum.OPERATION_FAILED.getCode();
        this.msg = msg;
    }

    public void setTrue(ConstantEnum constantEnum){
        this.status = true;
        this.code =  constantEnum.getCode();
        this.msg = constantEnum.getMsg();
    }

    public void setFalse(ConstantEnum constantEnum){
        this.status = false;
        this.code = constantEnum.getCode();
        this.msg = constantEnum.getMsg();
    }

    public void setFalse(BaseException e){
        this.status = false;
        this.code = e.getCode();
        this.msg = e.getMessage();
    }


    /**
     * 添加自定义fail方法
     * @param msg 消息
     * @param code 代码
     * @return 返回实体类
     */
    public static BaseRespDto fail(String msg,Integer code){
        BaseRespDto<String> baseRespDto = new BaseRespDto<>();
        baseRespDto.setStatus(false);
        baseRespDto.setCode(code);
        baseRespDto.setMsg(msg);
        return baseRespDto;
    }


    public static BaseRespDto fail(BaseException e){
        BaseRespDto<String> baseRespDto = new BaseRespDto<>();
        baseRespDto.setStatus(false);
        baseRespDto.setCode(e.getCode());
        baseRespDto.setMsg(e.getMessage());
        return baseRespDto;
    }

    public static BaseRespDto fail(String msg) {
        BaseRespDto<String> baseRespDto = new BaseRespDto<>();
        baseRespDto.setStatus(false);
        baseRespDto.setCode(-1);
        baseRespDto.setMsg(msg);
        return baseRespDto;
    }

    public static BaseRespDto fail(ConstantEnum constantEnum){
        BaseRespDto<String> baseRespDto = new BaseRespDto<>();
        baseRespDto.setStatus(false);
        baseRespDto.setCode(constantEnum.getCode());
        baseRespDto.setMsg(constantEnum.getMsg());
        return baseRespDto;
    }

    public static BaseRespDto fail(Object o){
        BaseRespDto<Object> baseRespDto = new BaseRespDto<>();
        baseRespDto.setStatus(false);
        baseRespDto.setData(o);
        baseRespDto.setMsg(ConstantEnum.OPERATION_FAILED.getMsg());
        baseRespDto.setCode(ConstantEnum.OPERATION_FAILED.getCode());
        return baseRespDto;
    }

    public static String getExceptionMessage(Throwable e){
        String causeMessage = e.getMessage();
        Throwable cause = e.getCause();
        if (cause != null){
            causeMessage = BaseRespDto.getExceptionMessage(e.getCause());
        }
        return causeMessage;
    }

    public static BaseRespDto fail(Exception e){
        BaseRespDto<String> baseRespDto = new BaseRespDto<>();
        baseRespDto.setStatus(false);
        String data = BaseRespDto.getExceptionMessage(e.getCause());
        baseRespDto.setData(data);
        baseRespDto.setMsg(data);
        baseRespDto.setCode(ConstantEnum.OPERATION_FAILED.getCode());
        return baseRespDto;
    }

    public static BaseRespDto fail(List<Object> objects){
        BaseRespDto<List<Object>> baseRespDto = new BaseRespDto<>();
        baseRespDto.setStatus(false);
        baseRespDto.setCode(ConstantEnum.OPERATION_FAILED.getCode());
        baseRespDto.setMsg(ConstantEnum.OPERATION_FAILED.getMsg());
        baseRespDto.setData(objects);
        return baseRespDto;
    }

    public static BaseRespDto success(){
        BaseRespDto<String> baseRespDto = new BaseRespDto<>();
        baseRespDto.setStatus(true);
        baseRespDto.setCode(ConstantEnum.OPERATION_SUCCESS.getCode());
        baseRespDto.setMsg(ConstantEnum.OPERATION_SUCCESS.getMsg());
        return baseRespDto;
    }

    public static BaseRespDto success(String data){
        BaseRespDto<String> baseRespDto = new BaseRespDto<>();
        baseRespDto.setStatus(true);
        baseRespDto.setCode(ConstantEnum.OPERATION_SUCCESS.getCode());
        baseRespDto.setMsg(ConstantEnum.OPERATION_SUCCESS.getMsg());
        baseRespDto.setData(data);
        return baseRespDto;
    }

    /**
     * 通过泛型来进行参数的返回的解析
     * @param k 泛型传入的data
     * @param <K> 泛型定义传入的data的类型
     * @return 返回返回实体类
     */
    public static <K> BaseRespDto success(K k){
        BaseRespDto<K> baseRespDto = new BaseRespDto<>();
        baseRespDto.setTrue();
        baseRespDto.setCode(ConstantEnum.OPERATION_SUCCESS.getCode());
        baseRespDto.setMsg(ConstantEnum.OPERATION_SUCCESS.getMsg());
        baseRespDto.setData(k);
        return baseRespDto;
    }






}
