/*
 * Decompiled with CFR 0.152.
 */
package io.afu.common.dto;

import io.afu.common.constant.CodeConstant;
import io.afu.common.constant.ConstantEnum;
import io.afu.common.exception.BaseException;
import java.util.List;

public class BaseRespDto<T> {
    private Boolean status;
    private Integer code;
    private String msg;
    private T data;

    public Boolean getStatus() {
        return this.status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        this.status = true;
        this.code = CodeConstant.OPERATION_SUCCESS;
        this.msg = "\u64cd\u4f5c\u6210\u529f";
        return this.data;
    }

    public void setData(T data) {
        this.status = true;
        this.code = CodeConstant.OPERATION_SUCCESS;
        this.msg = "\u64cd\u4f5c\u6210\u529f";
        this.data = data;
    }

    public void setTrue() {
        this.status = true;
        this.code = ConstantEnum.OPERATION_SUCCESS.getCode();
    }

    public void setFalse() {
        this.status = false;
        this.code = ConstantEnum.OPERATION_FAILED.getCode();
    }

    public void setTrueMsg(String msg) {
        this.status = true;
        this.code = ConstantEnum.OPERATION_SUCCESS.getCode();
        this.msg = msg;
    }

    public void setErrorMsg(String msg) {
        this.status = false;
        this.code = ConstantEnum.OPERATION_FAILED.getCode();
        this.msg = msg;
    }

    public void setTrue(ConstantEnum constantEnum) {
        this.status = true;
        this.code = constantEnum.getCode();
        this.msg = constantEnum.getMsg();
    }

    public void setFalse(ConstantEnum constantEnum) {
        this.status = false;
        this.code = constantEnum.getCode();
        this.msg = constantEnum.getMsg();
    }

    public void setFalse(BaseException e) {
        this.status = false;
        this.code = e.getCode();
        this.msg = e.getMessage();
    }

    public static BaseRespDto fail(String msg, Integer code) {
        BaseRespDto baseRespDto = new BaseRespDto();
        baseRespDto.setStatus(false);
        baseRespDto.setCode(code);
        baseRespDto.setMsg(msg);
        return baseRespDto;
    }

    public static BaseRespDto fail(BaseException e) {
        BaseRespDto baseRespDto = new BaseRespDto();
        baseRespDto.setStatus(false);
        baseRespDto.setCode(e.getCode());
        baseRespDto.setMsg(e.getMessage());
        return baseRespDto;
    }

    public static BaseRespDto fail(String msg) {
        BaseRespDto baseRespDto = new BaseRespDto();
        baseRespDto.setStatus(false);
        baseRespDto.setCode(-1);
        baseRespDto.setMsg(msg);
        return baseRespDto;
    }

    public static BaseRespDto fail(ConstantEnum constantEnum) {
        BaseRespDto baseRespDto = new BaseRespDto();
        baseRespDto.setStatus(false);
        baseRespDto.setCode(constantEnum.getCode());
        baseRespDto.setMsg(constantEnum.getMsg());
        return baseRespDto;
    }

    public static BaseRespDto fail(Object o) {
        BaseRespDto<Object> baseRespDto = new BaseRespDto<Object>();
        baseRespDto.setStatus(false);
        baseRespDto.setData(o);
        baseRespDto.setMsg(ConstantEnum.OPERATION_FAILED.getMsg());
        baseRespDto.setCode(ConstantEnum.OPERATION_FAILED.getCode());
        return baseRespDto;
    }

    public static BaseRespDto fail(List<Object> objects) {
        BaseRespDto<List<Object>> baseRespDto = new BaseRespDto<List<Object>>();
        baseRespDto.setStatus(false);
        baseRespDto.setCode(ConstantEnum.OPERATION_FAILED.getCode());
        baseRespDto.setMsg(ConstantEnum.OPERATION_FAILED.getMsg());
        baseRespDto.setData(objects);
        return baseRespDto;
    }

    public static BaseRespDto success() {
        BaseRespDto baseRespDto = new BaseRespDto();
        baseRespDto.setStatus(true);
        baseRespDto.setCode(ConstantEnum.OPERATION_SUCCESS.getCode());
        baseRespDto.setMsg(ConstantEnum.OPERATION_SUCCESS.getMsg());
        return baseRespDto;
    }

    public static BaseRespDto success(String data) {
        BaseRespDto<String> baseRespDto = new BaseRespDto<String>();
        baseRespDto.setStatus(true);
        baseRespDto.setCode(ConstantEnum.OPERATION_SUCCESS.getCode());
        baseRespDto.setMsg(ConstantEnum.OPERATION_SUCCESS.getMsg());
        baseRespDto.setData(data);
        return baseRespDto;
    }

    public static <K> BaseRespDto success(K k) {
        BaseRespDto<K> baseRespDto = new BaseRespDto<K>();
        baseRespDto.setTrue();
        baseRespDto.setCode(ConstantEnum.OPERATION_SUCCESS.getCode());
        baseRespDto.setMsg(ConstantEnum.OPERATION_SUCCESS.getMsg());
        baseRespDto.setData(k);
        return baseRespDto;
    }
}

