package io.afu.common.exception;


import io.afu.common.constant.ConstantEnum;

public class BaseException extends Exception {

    private static final long serialVersionUID = 2342341341L;

    private Integer code;

    public BaseException(){
        super();
    }

    public BaseException(String message){
        super(message);
    }

    public BaseException(String message, Integer code){
        super(message);
        this.code = code;
    }

    public BaseException(ConstantEnum constantEnum){
        super(constantEnum.getMsg());
        this.code = constantEnum.getCode();
    }

    public BaseException(Throwable cause){
        super(cause);
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
