/*
 * Decompiled with CFR 0.152.
 */
package io.aelf.utils;

import io.aelf.utils.ClientUtil;
import io.aelf.utils.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpUtilExt {
    protected static final Logger logger = LogManager.getLogger(HttpUtilExt.class);

    public static String sendGet(String reqUrl, String decodeCharset, String version) throws Exception {
        logger.debug("Request address:" + reqUrl);
        version = StringUtil.isBlank(version) ? "" : ";v=" + version;
        String chainContext = ClientUtil.sendGet(reqUrl, decodeCharset, "application/json" + version);
        if (StringUtil.toString(chainContext).length() > 0 && chainContext.contains("@ERROR:@")) {
            chainContext = chainContext.replace("@ERROR:@", "");
            throw new RuntimeException(chainContext);
        }
        logger.debug("Return parameters:" + chainContext);
        return chainContext;
    }

    public static String sendDelete(String reqUrl, String decodeCharset, String version) {
        logger.debug("Request address:" + reqUrl);
        version = StringUtil.isBlank(version) ? "" : ";v=" + version;
        String chainContext = ClientUtil.sendDelete(reqUrl, decodeCharset, "application/json" + version);
        logger.debug("Return parameters:" + chainContext);
        return chainContext;
    }

    public static String sendPost(String reqUrl, String params, String version) throws Exception {
        version = StringUtil.isBlank(version) ? "" : ";v=" + version;
        logger.debug("Request address:" + reqUrl);
        String chainContext = ClientUtil.sendPost(reqUrl, params, "UTF-8", "UTF-8", "application/json" + version);
        if (StringUtil.toString(chainContext).length() > 0 && chainContext.contains("@ERROR:@")) {
            chainContext = chainContext.replace("@ERROR:@", "");
            throw new RuntimeException(chainContext);
        }
        logger.debug("Return parameters:" + chainContext);
        return chainContext;
    }
}

