/*
 * Decompiled with CFR 0.152.
 */
package io.aelf.utils;

import io.aelf.utils.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientUtil {
    protected static final Logger logger = LogManager.getLogger(ClientUtil.class);

    private ClientUtil() {
    }

    private static HttpClient setProxy(Integer ... connectTimeout) {
        String proxySet = StringUtil.toString(System.getProperty("proxySet"));
        if (!"true".equals(proxySet)) {
            if (connectTimeout != null && connectTimeout.length > 0) {
                RequestConfig config = RequestConfig.custom().setConnectTimeout(connectTimeout[0].intValue()).build();
                CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(config).build();
                return httpClient;
            }
            DefaultHttpClient httpClient = new DefaultHttpClient();
            return httpClient;
        }
        String proxyType = System.getProperty("proxyType");
        String host = System.getProperty(proxyType + ".proxyHost");
        int port = Integer.parseInt(System.getProperty(proxyType + ".proxyPort"));
        HttpHost proxy = new HttpHost(host, port, proxyType);
        RequestConfig config = null;
        config = connectTimeout != null && connectTimeout.length > 0 ? RequestConfig.custom().setConnectTimeout(connectTimeout[0].intValue()).setProxy(proxy).build() : RequestConfig.custom().setProxy(proxy).build();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(config).build();
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGet(String reqUrl, String decodeCharset, String contentType) {
        long responseLength = 0L;
        String responseContent = null;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet httpGet = new HttpGet(reqUrl);
        try {
            ClientUtil.setProxy(new Integer[0]);
            if (StringUtils.isBlank((CharSequence)contentType)) {
                httpGet.setHeader("Content-Type", "application/x-www-form-urlencoded");
            } else {
                httpGet.setHeader("Content-Type", contentType);
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseLength = entity.getContentLength();
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)(decodeCharset == null ? "UTF-8" : decodeCharset));
                EntityUtils.consume((HttpEntity)entity);
            }
            if (200 != response.getStatusLine().getStatusCode()) {
                responseContent = "@ERROR:@" + responseContent;
            }
            logger.debug("Request address:" + httpGet.getURI());
            logger.debug("Response status:" + response.getStatusLine());
            logger.debug("Response length:" + responseLength);
            logger.debug("Response content:" + responseContent);
        }
        catch (Exception ex) {
            responseContent = "@ERROR:@" + ex.getMessage();
            logger.debug("sendGet Exception:", (Throwable)ex);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return responseContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendDelete(String reqUrl, String decodeCharset, String contentType) {
        long responseLength = 0L;
        String responseContent = null;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpDelete httpDelete = new HttpDelete(reqUrl);
        try {
            ClientUtil.setProxy(new Integer[0]);
            if (StringUtils.isBlank((CharSequence)contentType)) {
                httpDelete.setHeader("Content-Type", "application/x-www-form-urlencoded");
            } else {
                httpDelete.setHeader("Content-Type", contentType);
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseLength = entity.getContentLength();
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)(decodeCharset == null ? "UTF-8" : decodeCharset));
                EntityUtils.consume((HttpEntity)entity);
            }
            if (200 != response.getStatusLine().getStatusCode()) {
                responseContent = "@ERROR:@" + responseContent;
            }
            logger.debug("Request address:" + httpDelete.getURI());
            logger.debug("Response status:" + response.getStatusLine());
            logger.debug("Response length:" + responseLength);
            logger.debug("Response content:" + responseContent);
        }
        catch (Exception ex) {
            logger.error("sendDelete Exception:", (Throwable)ex);
            responseContent = "@ERROR:@" + ex.getMessage();
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return responseContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String reqUrl, String param, String encodeCharset, String decodeCharset, String contentType) {
        String responseContent = null;
        HttpClient httpClient = ClientUtil.setProxy(new Integer[0]);
        HttpPost httpPost = new HttpPost(reqUrl);
        try {
            StringEntity myEntity = new StringEntity(param, encodeCharset);
            if (StringUtils.isBlank((CharSequence)contentType)) {
                myEntity.setContentType("application/x-www-form-urlencoded");
            } else {
                myEntity.setContentType(contentType);
            }
            httpPost.setEntity((HttpEntity)myEntity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)(decodeCharset == null ? "UTF-8" : decodeCharset));
                EntityUtils.consume((HttpEntity)entity);
            }
            if (200 != response.getStatusLine().getStatusCode()) {
                responseContent = "@ERROR:@" + responseContent;
            }
        }
        catch (Exception ex) {
            logger.error("sendPost Exception:", (Throwable)ex);
            responseContent = "@ERROR:@" + ex.getMessage();
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return responseContent;
    }
}

