/*
 * Decompiled with CFR 0.152.
 */
package io.aelf.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.StringValue;
import io.aelf.protobuf.generated.Client;
import io.aelf.protobuf.generated.Core;
import io.aelf.schemas.AddPeerInput;
import io.aelf.schemas.BlockDto;
import io.aelf.schemas.ChainstatusDto;
import io.aelf.schemas.CreateRawTransactionInput;
import io.aelf.schemas.CreateRawTransactionOutput;
import io.aelf.schemas.ExecuteRawTransactionDto;
import io.aelf.schemas.ExecuteTransactionDto;
import io.aelf.schemas.KeyPairInfo;
import io.aelf.schemas.MerklePathDto;
import io.aelf.schemas.NetworkInfoOutput;
import io.aelf.schemas.PeerDto;
import io.aelf.schemas.SendRawTransactionInput;
import io.aelf.schemas.SendRawTransactionOutput;
import io.aelf.schemas.SendTransactionInput;
import io.aelf.schemas.SendTransactionOutput;
import io.aelf.schemas.SendTransactionsInput;
import io.aelf.schemas.TaskQueueInfoDto;
import io.aelf.schemas.TransactionPoolStatusOutput;
import io.aelf.schemas.TransactionResultDto;
import io.aelf.sdk.BlockChainSdk;
import io.aelf.sdk.NetSdk;
import io.aelf.utils.Base58Ext;
import io.aelf.utils.ByteArrayHelper;
import io.aelf.utils.Sha256;
import io.aelf.utils.StringUtil;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Sha256Hash;
import org.bouncycastle.util.encoders.Hex;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Sign;

public class AElfClient {
    private String AElfClientUrl;
    private String version = "1.0";
    private BlockChainSdk blcokChainSdk;
    private NetSdk netSdk;

    public AElfClient(String url) {
        this.AElfClientUrl = url;
        this.getBlockChainSdkObj();
        this.getNetSdkObj();
    }

    public AElfClient(String url, String version) {
        this.AElfClientUrl = url;
        this.version = version;
        this.getBlockChainSdkObj();
        this.getNetSdkObj();
    }

    private AElfClient() {
    }

    private BlockChainSdk getBlockChainSdkObj() {
        if (this.blcokChainSdk == null) {
            this.blcokChainSdk = new BlockChainSdk(this.AElfClientUrl, this.version);
        }
        return this.blcokChainSdk;
    }

    private NetSdk getNetSdkObj() {
        if (this.netSdk == null) {
            this.netSdk = new NetSdk(this.AElfClientUrl, this.version);
        }
        return this.netSdk;
    }

    public long getBlockHeight() throws Exception {
        return this.getBlockChainSdkObj().getBlockHeight();
    }

    public BlockDto getBlockByHash(String blockHash) throws Exception {
        return this.getBlockByHash(blockHash, false);
    }

    public BlockDto getBlockByHash(String blockHash, boolean includeTransactions) throws Exception {
        return this.getBlockChainSdkObj().getBlockByHash(blockHash, includeTransactions);
    }

    public BlockDto getBlockByHeight(long blockHeight) throws Exception {
        return this.getBlockByHeight(blockHeight, false);
    }

    public BlockDto getBlockByHeight(long blockHeight, boolean includeTransactions) throws Exception {
        return this.getBlockChainSdkObj().getBlockByHeight(blockHeight, includeTransactions);
    }

    public ChainstatusDto getChainStatus() throws Exception {
        return this.getBlockChainSdkObj().getChainStatus();
    }

    public byte[] getContractFileDescriptorSet(String address) throws Exception {
        return this.getBlockChainSdkObj().getContractFileDescriptorSet(address);
    }

    public List<TaskQueueInfoDto> getTaskQueueStatus() throws Exception {
        return this.getBlockChainSdkObj().getTaskQueueStatus();
    }

    public TransactionPoolStatusOutput getTransactionPoolStatus() throws Exception {
        return this.getBlockChainSdkObj().getTransactionPoolStatus();
    }

    public String executeTransaction(ExecuteTransactionDto input) throws Exception {
        return this.getBlockChainSdkObj().executeTransaction(input);
    }

    public CreateRawTransactionOutput createRawTransaction(CreateRawTransactionInput input) throws Exception {
        return this.getBlockChainSdkObj().createRawTransaction(input);
    }

    public String executeRawTransaction(ExecuteRawTransactionDto input) throws Exception {
        return this.getBlockChainSdkObj().executeRawTransaction(input);
    }

    public SendRawTransactionOutput sendRawTransaction(SendRawTransactionInput input) throws Exception {
        return this.getBlockChainSdkObj().sendRawTransaction(input);
    }

    public SendTransactionOutput sendTransaction(SendTransactionInput input) throws Exception {
        return this.getBlockChainSdkObj().sendTransaction(input);
    }

    public List<String> sendTransactions(SendTransactionsInput input) throws Exception {
        return this.getBlockChainSdkObj().sendTransactions(input);
    }

    public TransactionResultDto getTransactionResult(String transactionId) throws Exception {
        return this.getBlockChainSdkObj().getTransactionResult(transactionId);
    }

    public List<TransactionResultDto> getTransactionResults(String blockHash) throws Exception {
        return this.getTransactionResults(blockHash, 0, 10);
    }

    public List<TransactionResultDto> getTransactionResults(String blockHash, int offset, int limit) throws Exception {
        return this.getBlockChainSdkObj().getTransactionResults(blockHash, offset, limit);
    }

    public MerklePathDto getMerklePathByTransactionId(String transactionId) {
        return this.getBlockChainSdkObj().getMerklePathByTransactionId(transactionId);
    }

    public int getChainId() throws Exception {
        return this.getBlockChainSdkObj().getChainId();
    }

    public Boolean addPeer(AddPeerInput input) throws Exception {
        return this.getNetSdkObj().addPeer(input);
    }

    public Boolean removePeer(String address) throws Exception {
        return this.getNetSdkObj().removePeer(address);
    }

    public List<PeerDto> getPeers(Boolean withMetrics) throws Exception {
        return this.getNetSdkObj().getPeers(withMetrics);
    }

    public NetworkInfoOutput getNetworkInfo() throws Exception {
        return this.getNetSdkObj().getNetworkInfo();
    }

    public Core.Transaction.Builder generateTransaction(String from, String to, String methodName, byte[] params) throws Exception {
        ChainstatusDto chainStatus = this.getBlockChainSdkObj().getChainStatus();
        Core.Transaction.Builder transaction = Core.Transaction.newBuilder();
        Client.Address.Builder addressForm = Client.Address.newBuilder();
        Client.Address.Builder addressTo = Client.Address.newBuilder();
        addressForm.setValue(ByteString.copyFrom((byte[])Base58.decodeChecked((String)from)));
        addressTo.setValue(ByteString.copyFrom((byte[])Base58.decodeChecked((String)to)));
        Client.Address addressFormObj = addressForm.build();
        Client.Address addressToObj = addressTo.build();
        transaction.setFrom(addressFormObj);
        transaction.setTo(addressToObj);
        transaction.setMethodName(methodName);
        transaction.setParams(ByteString.copyFrom((byte[])params));
        transaction.setRefBlockNumber(chainStatus.getBestChainHeight());
        byte[] refBlockPrefix = ByteArrayHelper.hexToByteArray(chainStatus.getBestChainHash());
        refBlockPrefix = Arrays.copyOf(refBlockPrefix, 4);
        transaction.setRefBlockPrefix(ByteString.copyFrom((byte[])refBlockPrefix));
        return transaction;
    }

    public String signTransaction(String privateKeyHex, Core.Transaction transaction) throws Exception {
        byte[] transactionData = Sha256.getBytesSha256(transaction.toByteArray());
        return this.getSignatureWithPrivateKey(privateKeyHex, transactionData);
    }

    public String getGenesisContractAddress() throws Exception {
        ChainstatusDto chainstatusDto = this.getBlockChainSdkObj().getChainStatus();
        return chainstatusDto.getGenesisContractAddress();
    }

    public String getAddressFromPubKey(@Nullable String pubKey) {
        byte[] publicKey = ByteArrayHelper.hexToByteArray(pubKey);
        byte[] hashTwice = Sha256Hash.hashTwice((byte[])publicKey);
        String address = Base58Ext.encodeChecked(hashTwice);
        return address;
    }

    public String getFormattedAddress(String privateKey, String address) throws Exception {
        String chainIdString = this.getBlockChainSdkObj().getChainStatus().getChainId();
        String fromAddress = this.getAddressFromPrivateKey(privateKey);
        String toAddress = this.getContractAddressByName(privateKey, Sha256.getBytesSha256("AElf.ContractNames.Token"));
        String methodName = "GetPrimaryTokenSymbol";
        byte[] bytes = new byte[]{};
        Core.Transaction.Builder transaction = this.generateTransaction(fromAddress, toAddress, methodName, bytes);
        String signature = this.signTransaction(privateKey, transaction.build());
        transaction.setSignature(ByteString.copyFrom((byte[])ByteArrayHelper.hexToByteArray(signature)));
        Core.Transaction transactionObj = transaction.build();
        ExecuteTransactionDto executeTransactionDto = new ExecuteTransactionDto();
        executeTransactionDto.setRawTransaction(Hex.toHexString((byte[])transactionObj.toByteArray()));
        String response = this.blcokChainSdk.executeTransaction(executeTransactionDto);
        StringValue symbol = StringValue.parseFrom((byte[])ByteArrayHelper.hexToByteArray(response));
        return symbol.getValue() + "_" + address + "_" + chainIdString;
    }

    public KeyPairInfo generateKeyPairInfo() throws Exception {
        ECKey keyPair = new ECKey();
        String privateKey = keyPair.getPrivateKeyAsHex();
        String publicKey = keyPair.getPublicKeyAsHex();
        String address = this.getAddressFromPrivateKey(privateKey);
        KeyPairInfo keyPairInfo = new KeyPairInfo();
        keyPairInfo.setPrivateKey(privateKey);
        keyPairInfo.setPublicKey(publicKey);
        keyPairInfo.setAddress(address);
        return keyPairInfo;
    }

    public String getContractAddressByName(String privateKey, byte[] contractNameHash) throws Exception {
        String from = this.getAddressFromPrivateKey(privateKey);
        String to = this.getGenesisContractAddress();
        String methodName = "GetContractAddressByName";
        Client.Hash.Builder hash = Client.Hash.newBuilder();
        hash.setValue(ByteString.copyFrom((byte[])contractNameHash));
        Client.Hash hashObj = hash.build();
        Core.Transaction.Builder transaction = this.generateTransaction(from, to, methodName, hashObj.toByteArray());
        String signature = this.signTransaction(privateKey, transaction.build());
        transaction.setSignature(ByteString.copyFrom((byte[])ByteArrayHelper.hexToByteArray(signature)));
        Core.Transaction transactionObj = transaction.build();
        ExecuteTransactionDto executeTransactionDto = new ExecuteTransactionDto();
        executeTransactionDto.setRawTransaction(Hex.toHexString((byte[])transactionObj.toByteArray()));
        String response = this.blcokChainSdk.executeTransaction(executeTransactionDto);
        byte[] byteArray = ByteArrayHelper.hexToByteArray(response);
        Client.Address.getDefaultInstance();
        String base58Str = Base58Ext.encodeChecked(Client.Address.parseFrom(byteArray).getValue().toByteArray());
        return base58Str;
    }

    public String getAddressFromPrivateKey(String privateKey) {
        ECKey aelfKey = ECKey.fromPrivate((BigInteger)new BigInteger(privateKey, 16)).decompress();
        byte[] publicKey = aelfKey.getPubKey();
        byte[] hashTwice = Sha256Hash.hashTwice((byte[])publicKey);
        String address = Base58Ext.encodeChecked(hashTwice);
        return address;
    }

    public String getSignatureWithPrivateKey(String privateKey, byte[] txData) throws Exception {
        BigInteger privKey = new BigInteger(privateKey, 16);
        BigInteger pubKey = Sign.publicKeyFromPrivate((BigInteger)privKey);
        ECKeyPair keyPair = new ECKeyPair(privKey, pubKey);
        Sign.SignatureData signature = Sign.signMessage((byte[])txData, (ECKeyPair)keyPair, (boolean)false);
        String signatureStr = Hex.toHexString((byte[])signature.getR()) + Hex.toHexString((byte[])signature.getS());
        String res = StringUtil.toString(signature.getV() - 27);
        if (res.length() == 1) {
            res = "0" + res;
        }
        signatureStr = signatureStr + res;
        return signatureStr;
    }

    public boolean isConnected() {
        try {
            this.getBlockChainSdkObj().getChainStatus();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

