/*
 * Decompiled with CFR 0.152.
 */
package io.aelf.utils;

import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class BitConverter {
    public static byte[] getBytes(boolean data) {
        byte[] bytes = new byte[]{(byte)(data ? 1 : 0)};
        return bytes;
    }

    public static byte[] getBytes(short data) {
        byte[] bytes = new byte[2];
        if (BitConverter.isLittleEndian()) {
            bytes[0] = (byte)(data & 0xFF);
            bytes[1] = (byte)((data & 0xFF00) >> 8);
        } else {
            bytes[1] = (byte)(data & 0xFF);
            bytes[0] = (byte)((data & 0xFF00) >> 8);
        }
        return bytes;
    }

    public static byte[] getBytes(char data) {
        byte[] bytes = new byte[2];
        if (BitConverter.isLittleEndian()) {
            bytes[0] = (byte)data;
            bytes[1] = (byte)(data >> 8);
        } else {
            bytes[1] = (byte)data;
            bytes[0] = (byte)(data >> 8);
        }
        return bytes;
    }

    public static byte[] getBytes(int data) {
        byte[] bytes = new byte[4];
        if (BitConverter.isLittleEndian()) {
            bytes[0] = (byte)(data & 0xFF);
            bytes[1] = (byte)((data & 0xFF00) >> 8);
            bytes[2] = (byte)((data & 0xFF0000) >> 16);
            bytes[3] = (byte)((data & 0xFF000000) >> 24);
        } else {
            bytes[3] = (byte)(data & 0xFF);
            bytes[2] = (byte)((data & 0xFF00) >> 8);
            bytes[1] = (byte)((data & 0xFF0000) >> 16);
            bytes[0] = (byte)((data & 0xFF000000) >> 24);
        }
        return bytes;
    }

    public static byte[] getBytes(long data) {
        byte[] bytes = new byte[8];
        if (BitConverter.isLittleEndian()) {
            bytes[0] = (byte)(data & 0xFFL);
            bytes[1] = (byte)(data >> 8 & 0xFFL);
            bytes[2] = (byte)(data >> 16 & 0xFFL);
            bytes[3] = (byte)(data >> 24 & 0xFFL);
            bytes[4] = (byte)(data >> 32 & 0xFFL);
            bytes[5] = (byte)(data >> 40 & 0xFFL);
            bytes[6] = (byte)(data >> 48 & 0xFFL);
            bytes[7] = (byte)(data >> 56 & 0xFFL);
        } else {
            bytes[7] = (byte)(data & 0xFFL);
            bytes[6] = (byte)(data >> 8 & 0xFFL);
            bytes[5] = (byte)(data >> 16 & 0xFFL);
            bytes[4] = (byte)(data >> 24 & 0xFFL);
            bytes[3] = (byte)(data >> 32 & 0xFFL);
            bytes[2] = (byte)(data >> 40 & 0xFFL);
            bytes[1] = (byte)(data >> 48 & 0xFFL);
            bytes[0] = (byte)(data >> 56 & 0xFFL);
        }
        return bytes;
    }

    public static byte[] getBytes(float data) {
        return BitConverter.getBytes(Float.floatToIntBits(data));
    }

    public static byte[] getBytes(double data) {
        return BitConverter.getBytes(Double.doubleToLongBits(data));
    }

    public static byte[] getBytes(String data) {
        return data.getBytes(Charset.forName("UTF-8"));
    }

    public static byte[] getBytes(String data, String charsetName) {
        return data.getBytes(Charset.forName(charsetName));
    }

    public static boolean toBoolean(byte[] bytes) {
        return bytes[0] != 0;
    }

    public static boolean toBoolean(byte[] bytes, int startIndex) {
        return BitConverter.toBoolean(BitConverter.copyFrom(bytes, startIndex, 1));
    }

    public static short toShort(byte[] bytes) {
        if (BitConverter.isLittleEndian()) {
            return (short)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
        }
        return (short)(0xFF & bytes[1] | 0xFF00 & bytes[0] << 8);
    }

    public static short toShort(byte[] bytes, int startIndex) {
        return BitConverter.toShort(BitConverter.copyFrom(bytes, startIndex, 2));
    }

    public static char toChar(byte[] bytes) {
        if (BitConverter.isLittleEndian()) {
            return (char)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
        }
        return (char)(0xFF & bytes[1] | 0xFF00 & bytes[0] << 8);
    }

    public static char toChar(byte[] bytes, int startIndex) {
        return BitConverter.toChar(BitConverter.copyFrom(bytes, startIndex, 2));
    }

    public static int toInt(byte[] bytes) {
        if (BitConverter.isLittleEndian()) {
            return 0xFF & bytes[0] | 0xFF00 & bytes[1] << 8 | 0xFF0000 & bytes[2] << 16 | 0xFF000000 & bytes[3] << 24;
        }
        return 0xFF & bytes[3] | 0xFF00 & bytes[2] << 8 | 0xFF0000 & bytes[1] << 16 | 0xFF000000 & bytes[0] << 24;
    }

    public static int toInt(byte[] bytes, int startIndex) {
        return BitConverter.toInt(BitConverter.copyFrom(bytes, startIndex, 4));
    }

    public static long toLong(byte[] bytes) {
        if (BitConverter.isLittleEndian()) {
            return 0xFFL & (long)bytes[0] | 0xFF00L & (long)bytes[1] << 8 | 0xFF0000L & (long)bytes[2] << 16 | 0xFF000000L & (long)bytes[3] << 24 | 0xFF00000000L & (long)bytes[4] << 32 | 0xFF0000000000L & (long)bytes[5] << 40 | 0xFF000000000000L & (long)bytes[6] << 48 | 0xFF00000000000000L & (long)bytes[7] << 56;
        }
        return 0xFFL & (long)bytes[7] | 0xFF00L & (long)bytes[6] << 8 | 0xFF0000L & (long)bytes[5] << 16 | 0xFF000000L & (long)bytes[4] << 24 | 0xFF00000000L & (long)bytes[3] << 32 | 0xFF0000000000L & (long)bytes[2] << 40 | 0xFF000000000000L & (long)bytes[1] << 48 | 0xFF00000000000000L & (long)bytes[0] << 56;
    }

    public static long toLong(byte[] bytes, int startIndex) {
        return BitConverter.toLong(BitConverter.copyFrom(bytes, startIndex, 8));
    }

    public static float toFloat(byte[] bytes) {
        return Float.intBitsToFloat(BitConverter.toInt(bytes));
    }

    public static float toFloat(byte[] bytes, int startIndex) {
        return Float.intBitsToFloat(BitConverter.toInt(BitConverter.copyFrom(bytes, startIndex, 4)));
    }

    public static double toDouble(byte[] bytes) {
        return Double.longBitsToDouble(BitConverter.toLong(bytes));
    }

    public static double toDouble(byte[] bytes, int startIndex) {
        return Double.longBitsToDouble(BitConverter.toLong(BitConverter.copyFrom(bytes, startIndex, 8)));
    }

    public static String toString(byte[] bytes) {
        return new String(bytes, Charset.forName("UTF-8"));
    }

    public static String toString(byte[] bytes, String charsetName) {
        return new String(bytes, Charset.forName(charsetName));
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        int imax = bytes.length - 1;
        if (imax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(String.format("%02x", bytes[i] & 0xFF));
            if (i == imax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static byte[] copyFrom(byte[] src, int off, int len) {
        byte[] bits = new byte[len];
        int i = off;
        for (int j = 0; i < src.length && j < len; ++i, ++j) {
            bits[j] = src[i];
        }
        return bits;
    }

    private static boolean isLittleEndian() {
        return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    }
}

