/*
 * Decompiled with CFR 0.152.
 */
package io.aelf.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import io.aelf.protobuf.generated.TransactionFee;
import io.aelf.schemas.LogEventDto;
import io.aelf.schemas.TransactionResultDto;
import io.aelf.utils.StringUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class TransactionResultDtoExtension {
    public static HashMap<String, Long> getTransactionFees(TransactionResultDto transactionResultDto) throws InvalidProtocolBufferException {
        GeneratedMessageV3 info;
        byte[] byteStringMessage;
        Base64 base64;
        HashMap<String, Long> transactionFeesDict = new HashMap<String, Long>();
        if (transactionResultDto == null || transactionResultDto.getLogs() == null) {
            return transactionFeesDict;
        }
        List<LogEventDto> eventLogs = transactionResultDto.getLogs();
        for (LogEventDto log : eventLogs) {
            if (!StringUtil.toString(log.getName()).contains("TransactionFeeCharged")) continue;
            base64 = new Base64();
            byteStringMessage = base64.decode(log.getNonIndexed());
            info = TransactionFee.TransactionFeeCharged.parseFrom(ByteString.copyFrom((byte[])byteStringMessage));
            transactionFeesDict.put(info.getSymbol(), info.getAmount());
        }
        for (LogEventDto log : eventLogs) {
            if (!StringUtil.toString(log.getName()).contains("ResourceTokenCharged")) continue;
            base64 = new Base64();
            byteStringMessage = base64.decode(log.getNonIndexed());
            info = TransactionFee.ResourceTokenCharged.parseFrom(ByteString.copyFrom((byte[])byteStringMessage));
            transactionFeesDict.put(info.getSymbol(), info.getAmount());
        }
        return transactionFeesDict;
    }
}

