/*
 * Decompiled with CFR 0.152.
 */
package io.aelf.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.aelf.utils.MapEntry;
import io.aelf.utils.StringUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public final class JsonUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectMapper UNKNOWN_PROPERTIES_MAPPER = new ObjectMapper();

    public static String toJsonString(Object value) {
        if (value == null) {
            return null;
        }
        StringWriter writer = new StringWriter(1000);
        try {
            MAPPER.writeValue((Writer)writer, value);
        }
        catch (IOException var3) {
            throw new RuntimeException(var3);
        }
        return writer.toString();
    }

    public static MapEntry parseObject(String value) {
        return StringUtil.isBlank(value) ? null : JsonUtil.parseObject(value, MapEntry.class);
    }

    public static <T> T parseObject(String value, Class<T> clazz, boolean failOnUnknowProperties) {
        if (StringUtil.isBlank(value)) {
            return null;
        }
        try {
            return (T)(failOnUnknowProperties ? MAPPER.readValue(value, clazz) : UNKNOWN_PROPERTIES_MAPPER.readValue(value, clazz));
        }
        catch (IOException var4) {
            throw new RuntimeException(var4);
        }
    }

    public static <T> T parseObject(String value, Class<T> clazz) {
        return JsonUtil.parseObject(value, clazz, true);
    }

    static {
        UNKNOWN_PROPERTIES_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

