/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codec.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import io.activej.codec.StructuredCodecs;
import io.activej.codec.StructuredDecoder;
import io.activej.codec.StructuredInput;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.exception.UncheckedException;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class JsonStructuredInput
implements StructuredInput {
    private final JsonReader reader;

    public JsonStructuredInput(JsonReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean readBoolean() throws MalformedDataException {
        try {
            return this.reader.nextBoolean();
        }
        catch (MalformedJsonException | EOFException | IllegalStateException e) {
            throw new MalformedDataException(e);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    public byte readByte() throws MalformedDataException {
        int n = this.readInt();
        if (n != (n & 0xFF)) {
            throw new MalformedDataException("Expected byte, but was: " + n);
        }
        return (byte)n;
    }

    @Override
    public int readInt() throws MalformedDataException {
        try {
            return this.reader.nextInt();
        }
        catch (MalformedJsonException | EOFException | IllegalStateException | NumberFormatException e) {
            throw new MalformedDataException(e);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    public long readLong() throws MalformedDataException {
        try {
            return this.reader.nextLong();
        }
        catch (MalformedJsonException | EOFException | IllegalStateException | NumberFormatException e) {
            throw new MalformedDataException(e);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    public int readInt32() throws MalformedDataException {
        return this.readInt();
    }

    @Override
    public long readLong64() throws MalformedDataException {
        return this.readLong();
    }

    @Override
    public float readFloat() throws MalformedDataException {
        return (float)this.readDouble();
    }

    @Override
    public double readDouble() throws MalformedDataException {
        try {
            return this.reader.nextDouble();
        }
        catch (MalformedJsonException | EOFException | IllegalStateException | NumberFormatException e) {
            throw new MalformedDataException(e);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    public byte[] readBytes() throws MalformedDataException {
        try {
            return Base64.getDecoder().decode(this.readString());
        }
        catch (IllegalArgumentException e) {
            throw new MalformedDataException((Throwable)e);
        }
    }

    @Override
    public String readString() throws MalformedDataException {
        try {
            return this.reader.nextString();
        }
        catch (MalformedJsonException | EOFException | IllegalStateException | NumberFormatException e) {
            throw new MalformedDataException(e);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    public void readNull() throws MalformedDataException {
        try {
            this.reader.nextNull();
        }
        catch (MalformedJsonException | EOFException | IllegalStateException e) {
            throw new MalformedDataException(e);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> T readNullable(StructuredDecoder<T> decoder) throws MalformedDataException {
        try {
            if (this.reader.peek() == JsonToken.NULL) {
                this.reader.nextNull();
                return null;
            }
            return decoder.decode(this);
        }
        catch (MalformedJsonException | EOFException | IllegalStateException e) {
            throw new MalformedDataException(e);
        }
        catch (UncheckedException e) {
            throw (MalformedDataException)e.propagate(MalformedDataException.class);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> T readTuple(StructuredDecoder<T> decoder) throws MalformedDataException {
        try {
            this.reader.beginArray();
            T result = decoder.decode(this);
            this.reader.endArray();
            return result;
        }
        catch (MalformedJsonException | EOFException | IllegalStateException e) {
            throw new MalformedDataException(e);
        }
        catch (UncheckedException e) {
            throw (MalformedDataException)e.propagate(MalformedDataException.class);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> T readObject(StructuredDecoder<T> decoder) throws MalformedDataException {
        try {
            this.reader.beginObject();
            T result = decoder.decode(this);
            this.reader.endObject();
            return result;
        }
        catch (MalformedJsonException | EOFException | IllegalStateException e) {
            throw new MalformedDataException(e);
        }
        catch (UncheckedException e) {
            throw (MalformedDataException)e.propagate(MalformedDataException.class);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> List<T> readList(StructuredDecoder<T> decoder) throws MalformedDataException {
        try {
            ArrayList<T> list = new ArrayList<T>();
            this.reader.beginArray();
            while (this.reader.hasNext()) {
                T item = decoder.decode(this);
                list.add(item);
            }
            this.reader.endArray();
            return list;
        }
        catch (MalformedJsonException | EOFException | IllegalStateException e) {
            throw new MalformedDataException(e);
        }
        catch (UncheckedException e) {
            throw (MalformedDataException)e.propagate(MalformedDataException.class);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    public <K, V> Map<K, V> readMap(StructuredDecoder<K> keyDecoder, StructuredDecoder<V> valueDecoder) throws MalformedDataException {
        try {
            LinkedHashMap<String, V> map = new LinkedHashMap<String, V>();
            if (keyDecoder == StructuredCodecs.STRING_CODEC) {
                this.reader.beginObject();
                while (this.reader.hasNext()) {
                    String key = this.reader.nextName();
                    V value = valueDecoder.decode(this);
                    map.put(key, value);
                }
                this.reader.endObject();
            } else {
                this.reader.beginArray();
                while (this.reader.hasNext()) {
                    this.reader.beginArray();
                    K key = keyDecoder.decode(this);
                    V value = valueDecoder.decode(this);
                    map.put((String)key, value);
                    this.reader.endArray();
                }
                this.reader.endArray();
            }
            return map;
        }
        catch (MalformedJsonException | EOFException | IllegalStateException | NumberFormatException e) {
            throw new MalformedDataException(e);
        }
        catch (UncheckedException e) {
            throw (MalformedDataException)e.propagate(MalformedDataException.class);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    public boolean hasNext() throws MalformedDataException {
        try {
            JsonToken token = this.reader.peek();
            return token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT;
        }
        catch (MalformedJsonException | EOFException e) {
            throw new MalformedDataException(e);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    public String readKey() throws MalformedDataException {
        try {
            return this.reader.nextName();
        }
        catch (MalformedJsonException | EOFException | IllegalStateException | NumberFormatException e) {
            throw new MalformedDataException(e);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> T readCustom(Type type) throws MalformedDataException {
        throw new UnsupportedOperationException("No custom type readers");
    }

    @Override
    public EnumSet<StructuredInput.Token> getNext() throws MalformedDataException {
        JsonToken jsonToken;
        try {
            jsonToken = this.reader.peek();
        }
        catch (MalformedJsonException | EOFException e) {
            throw new MalformedDataException(e);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        switch (jsonToken) {
            case NULL: {
                return EnumSet.of(StructuredInput.Token.NULL);
            }
            case BOOLEAN: {
                return EnumSet.of(StructuredInput.Token.BOOLEAN);
            }
            case NUMBER: {
                return EnumSet.of(StructuredInput.Token.BYTE, StructuredInput.Token.INT, StructuredInput.Token.LONG, StructuredInput.Token.FLOAT, StructuredInput.Token.DOUBLE);
            }
            case STRING: {
                return EnumSet.of(StructuredInput.Token.STRING, StructuredInput.Token.BYTES);
            }
            case BEGIN_ARRAY: {
                return EnumSet.of(StructuredInput.Token.LIST, StructuredInput.Token.TUPLE);
            }
            case BEGIN_OBJECT: {
                return EnumSet.of(StructuredInput.Token.MAP, StructuredInput.Token.OBJECT);
            }
        }
        throw new MalformedDataException("Invalid token: " + jsonToken);
    }
}

