/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codec.binary;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.codec.StructuredEncoder;
import io.activej.codec.StructuredOutput;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public final class BinaryStructuredOutput
implements StructuredOutput {
    private ByteBuf buf = ByteBufPool.allocate((int)256);

    public ByteBuf getBuf() {
        return this.buf;
    }

    @Override
    public void writeBoolean(boolean value) {
        this.buf = ByteBufPool.ensureWriteRemaining((ByteBuf)this.buf, (int)1);
        this.buf.writeBoolean(value);
    }

    @Override
    public void writeByte(byte value) {
        this.buf = ByteBufPool.ensureWriteRemaining((ByteBuf)this.buf, (int)1);
        this.buf.writeByte(value);
    }

    @Override
    public void writeInt(int value) {
        this.buf = ByteBufPool.ensureWriteRemaining((ByteBuf)this.buf, (int)5);
        this.buf.writeVarInt(value);
    }

    @Override
    public void writeLong(long value) {
        this.buf = ByteBufPool.ensureWriteRemaining((ByteBuf)this.buf, (int)9);
        this.buf.writeVarLong(value);
    }

    @Override
    public void writeInt32(int value) {
        this.buf = ByteBufPool.ensureWriteRemaining((ByteBuf)this.buf, (int)4);
        this.buf.writeInt(value);
    }

    @Override
    public void writeLong64(long value) {
        this.buf = ByteBufPool.ensureWriteRemaining((ByteBuf)this.buf, (int)8);
        this.buf.writeLong(value);
    }

    @Override
    public void writeFloat(float value) {
        this.buf = ByteBufPool.ensureWriteRemaining((ByteBuf)this.buf, (int)4);
        this.buf.writeFloat(value);
    }

    @Override
    public void writeDouble(double value) {
        this.buf = ByteBufPool.ensureWriteRemaining((ByteBuf)this.buf, (int)8);
        this.buf.writeDouble(value);
    }

    @Override
    public void writeBytes(byte[] bytes, int off, int len) {
        this.buf = ByteBufPool.ensureWriteRemaining((ByteBuf)this.buf, (int)(5 + len));
        this.buf.writeVarInt(len);
        this.buf.write(bytes, off, len);
    }

    @Override
    public void writeString(String value) {
        this.buf = ByteBufPool.ensureWriteRemaining((ByteBuf)this.buf, (int)(5 + value.length() * 5));
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.buf.writeVarInt(bytes.length);
        this.buf.write(bytes);
    }

    @Override
    public void writeNull() {
        this.writeBoolean(false);
    }

    @Override
    public <T> void writeNullable(StructuredEncoder<T> encoder, T value) {
        if (value != null) {
            this.writeBoolean(true);
            encoder.encode(this, value);
        } else {
            this.writeBoolean(false);
        }
    }

    @Override
    public <T> void writeList(StructuredEncoder<T> encoder, List<T> list) {
        this.writeInt(list.size());
        for (T item : list) {
            encoder.encode(this, item);
        }
    }

    @Override
    public <K, V> void writeMap(StructuredEncoder<K> keyEncoder, StructuredEncoder<V> valueEncoder, Map<K, V> map) {
        this.writeInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keyEncoder.encode(this, entry.getKey());
            valueEncoder.encode(this, entry.getValue());
        }
    }

    @Override
    public <T> void writeTuple(StructuredEncoder<T> encoder, T value) {
        encoder.encode(this, value);
    }

    @Override
    public <T> void writeObject(StructuredEncoder<T> encoder, T value) {
        encoder.encode(this, value);
    }

    @Override
    public void writeKey(String field) {
        this.writeString(field);
    }

    @Override
    public <T> void writeCustom(Type type, T value) {
        throw new UnsupportedOperationException("No custom type writers");
    }
}

