/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codec.binary;

import io.activej.bytebuf.ByteBuf;
import io.activej.codec.StructuredDecoder;
import io.activej.codec.StructuredInput;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.exception.UncheckedException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class BinaryStructuredInput
implements StructuredInput {
    private final ByteBuf buf;

    public BinaryStructuredInput(ByteBuf buf) {
        this.buf = buf;
    }

    @Override
    public boolean readBoolean() throws MalformedDataException {
        try {
            return this.buf.readBoolean();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MalformedDataException((Throwable)e);
        }
    }

    @Override
    public byte readByte() throws MalformedDataException {
        try {
            return this.buf.readByte();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MalformedDataException((Throwable)e);
        }
    }

    @Override
    public int readInt() throws MalformedDataException {
        try {
            return this.buf.readVarInt();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalStateException e) {
            throw new MalformedDataException((Throwable)e);
        }
    }

    @Override
    public long readLong() throws MalformedDataException {
        try {
            return this.buf.readVarLong();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalStateException e) {
            throw new MalformedDataException((Throwable)e);
        }
    }

    @Override
    public int readInt32() throws MalformedDataException {
        try {
            return this.buf.readInt();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MalformedDataException((Throwable)e);
        }
    }

    @Override
    public long readLong64() throws MalformedDataException {
        try {
            return this.buf.readLong();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MalformedDataException((Throwable)e);
        }
    }

    @Override
    public float readFloat() throws MalformedDataException {
        try {
            return this.buf.readFloat();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MalformedDataException((Throwable)e);
        }
    }

    @Override
    public double readDouble() throws MalformedDataException {
        try {
            return this.buf.readDouble();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MalformedDataException((Throwable)e);
        }
    }

    @Override
    public byte[] readBytes() throws MalformedDataException {
        int length = this.readInt();
        if (length < 0 || length > this.buf.readRemaining()) {
            throw new MalformedDataException("Invalid length: " + length + ", remaining: " + this.buf.readRemaining() + ", buf: " + this.buf);
        }
        byte[] result = new byte[length];
        this.buf.read(result);
        return result;
    }

    @Override
    public String readString() throws MalformedDataException {
        int length = this.readInt();
        if (length == 0) {
            return "";
        }
        if (length > this.buf.readRemaining()) {
            throw new MalformedDataException("Read string length is greater than the remaining data");
        }
        String result = new String(this.buf.array(), this.buf.head(), length, StandardCharsets.UTF_8);
        this.buf.moveHead(length);
        return result;
    }

    @Override
    public void readNull() throws MalformedDataException {
        if (this.readBoolean()) {
            throw new MalformedDataException("Expected NULL value");
        }
    }

    @Override
    @Nullable
    public <T> T readNullable(StructuredDecoder<T> decoder) throws MalformedDataException {
        try {
            return this.readBoolean() ? (T)decoder.decode(this) : null;
        }
        catch (UncheckedException e) {
            throw (MalformedDataException)e.propagate(MalformedDataException.class);
        }
    }

    @Override
    public <T> List<T> readList(StructuredDecoder<T> decoder) throws MalformedDataException {
        int size = this.readInt();
        ArrayList<T> list = new ArrayList<T>(size);
        try {
            for (int i = 0; i < size; ++i) {
                list.add(decoder.decode(this));
            }
        }
        catch (UncheckedException e) {
            throw (MalformedDataException)e.propagate(MalformedDataException.class);
        }
        return list;
    }

    @Override
    public <K, V> Map<K, V> readMap(StructuredDecoder<K> keyDecoder, StructuredDecoder<V> valueDecoder) throws MalformedDataException {
        int size = this.readInt();
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        try {
            for (int i = 0; i < size; ++i) {
                map.put(keyDecoder.decode(this), valueDecoder.decode(this));
            }
        }
        catch (UncheckedException e) {
            throw (MalformedDataException)e.propagate(MalformedDataException.class);
        }
        return map;
    }

    @Override
    public <T> T readTuple(StructuredDecoder<T> decoder) throws MalformedDataException {
        try {
            return decoder.decode(this);
        }
        catch (UncheckedException e) {
            throw (MalformedDataException)e.propagate(MalformedDataException.class);
        }
    }

    @Override
    public <T> T readObject(StructuredDecoder<T> decoder) throws MalformedDataException {
        try {
            return decoder.decode(this);
        }
        catch (UncheckedException e) {
            throw (MalformedDataException)e.propagate(MalformedDataException.class);
        }
    }

    @Override
    public boolean hasNext() throws MalformedDataException {
        throw new UnsupportedOperationException("hasNext() is not supported for binary data");
    }

    @Override
    public String readKey() throws MalformedDataException {
        return this.readString();
    }

    @Override
    public <T> T readCustom(Type type) throws MalformedDataException {
        throw new UnsupportedOperationException("No custom type readers");
    }

    @Override
    public EnumSet<StructuredInput.Token> getNext() throws MalformedDataException {
        throw new UnsupportedOperationException("getNext() is not supported for binary data");
    }
}

