/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codec;

import io.activej.codec.StructuredDecoder;
import io.activej.common.exception.MalformedDataException;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public interface StructuredInput {
    public void readNull() throws MalformedDataException;

    public boolean readBoolean() throws MalformedDataException;

    public byte readByte() throws MalformedDataException;

    public int readInt() throws MalformedDataException;

    public long readLong() throws MalformedDataException;

    public int readInt32() throws MalformedDataException;

    public long readLong64() throws MalformedDataException;

    public float readFloat() throws MalformedDataException;

    public double readDouble() throws MalformedDataException;

    public byte[] readBytes() throws MalformedDataException;

    public String readString() throws MalformedDataException;

    @Nullable
    public <T> T readNullable(StructuredDecoder<T> var1) throws MalformedDataException;

    public boolean hasNext() throws MalformedDataException;

    public String readKey() throws MalformedDataException;

    default public void readKey(String expectedName) throws MalformedDataException {
        String actualName = this.readKey();
        if (!expectedName.equals(actualName)) {
            throw new MalformedDataException("Expected field: " + expectedName + ", but was: " + actualName);
        }
    }

    default public <T> T readKey(String expectedName, StructuredDecoder<T> decoder) throws MalformedDataException {
        this.readKey(expectedName);
        return decoder.decode(this);
    }

    public <T> List<T> readList(StructuredDecoder<T> var1) throws MalformedDataException;

    public <K, V> Map<K, V> readMap(StructuredDecoder<K> var1, StructuredDecoder<V> var2) throws MalformedDataException;

    public <T> T readTuple(StructuredDecoder<T> var1) throws MalformedDataException;

    public <T> T readObject(StructuredDecoder<T> var1) throws MalformedDataException;

    default public void readTuple(DecoderRunnable decoder) throws MalformedDataException {
        this.readTuple((StructuredInput in) -> {
            decoder.run();
            return null;
        });
    }

    default public void readObject(DecoderRunnable decoder) throws MalformedDataException {
        this.readObject((StructuredInput in) -> {
            decoder.run();
            return null;
        });
    }

    public <T> T readCustom(Type var1) throws MalformedDataException;

    public EnumSet<Token> getNext() throws MalformedDataException;

    @FunctionalInterface
    public static interface DecoderRunnable {
        public void run() throws MalformedDataException;
    }

    public static enum Token {
        NULL,
        BOOLEAN,
        BYTE,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING,
        BYTES,
        LIST,
        MAP,
        TUPLE,
        OBJECT;

    }
}

