/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codec;

import io.activej.codec.StructuredCodec;
import io.activej.codec.StructuredInput;
import io.activej.codec.StructuredOutput;
import io.activej.common.Checks;
import io.activej.common.api.DecoderFunction;
import io.activej.common.collection.CollectionUtils;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.exception.UncheckedException;
import io.activej.common.tuple.TupleDecoder0;
import io.activej.common.tuple.TupleDecoder1;
import io.activej.common.tuple.TupleDecoder2;
import io.activej.common.tuple.TupleDecoder3;
import io.activej.common.tuple.TupleDecoder4;
import io.activej.common.tuple.TupleDecoder5;
import io.activej.common.tuple.TupleDecoder6;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class StructuredCodecs {
    public static final StructuredCodec<Boolean> BOOLEAN_CODEC = new StructuredCodec<Boolean>(){

        @Override
        public void encode(StructuredOutput out, Boolean value) {
            out.writeBoolean(value);
        }

        @Override
        public Boolean decode(StructuredInput in) throws MalformedDataException {
            return in.readBoolean();
        }
    };
    public static final StructuredCodec<Character> CHARACTER_CODEC = new StructuredCodec<Character>(){

        @Override
        public void encode(StructuredOutput out, Character value) {
            out.writeString(value + "");
        }

        @Override
        public Character decode(StructuredInput in) throws MalformedDataException {
            String v = in.readString();
            if (v.length() == 1) {
                return Character.valueOf(v.charAt(0));
            }
            throw new MalformedDataException("Read a string with length != 1 while trying to read a character");
        }
    };
    public static final StructuredCodec<Byte> BYTE_CODEC = new StructuredCodec<Byte>(){

        @Override
        public void encode(StructuredOutput out, Byte value) {
            out.writeInt((int)(value & 0xFF));
        }

        @Override
        public Byte decode(StructuredInput in) throws MalformedDataException {
            int v = in.readInt();
            if (v >= 0 && v <= 255) {
                return (byte)v;
            }
            throw new MalformedDataException("Read an int not in range [0, 255] while trying to read a byte");
        }
    };
    public static final StructuredCodec<Short> SHORT_CODEC = new StructuredCodec<Short>(){

        @Override
        public void encode(StructuredOutput out, Short value) {
            out.writeInt(value.shortValue());
        }

        @Override
        public Short decode(StructuredInput in) throws MalformedDataException {
            int v = in.readInt();
            if (v >= Short.MIN_VALUE && v <= Short.MAX_VALUE) {
                return (short)v;
            }
            throw new MalformedDataException("Read an int not in range [-32768, 32767] while trying to read a short");
        }
    };
    public static final StructuredCodec<Integer> INT_CODEC = new StructuredCodec<Integer>(){

        @Override
        public void encode(StructuredOutput out, Integer value) {
            out.writeInt(value);
        }

        @Override
        public Integer decode(StructuredInput in) throws MalformedDataException {
            return in.readInt();
        }
    };
    public static final StructuredCodec<Long> LONG_CODEC = new StructuredCodec<Long>(){

        @Override
        public void encode(StructuredOutput out, Long value) {
            out.writeLong(value);
        }

        @Override
        public Long decode(StructuredInput in) throws MalformedDataException {
            return in.readLong();
        }
    };
    public static final StructuredCodec<Integer> INT32_CODEC = new StructuredCodec<Integer>(){

        @Override
        public void encode(StructuredOutput out, Integer value) {
            out.writeInt32(value);
        }

        @Override
        public Integer decode(StructuredInput in) throws MalformedDataException {
            return in.readInt32();
        }
    };
    public static final StructuredCodec<Long> LONG64_CODEC = new StructuredCodec<Long>(){

        @Override
        public void encode(StructuredOutput out, Long value) {
            out.writeLong64(value);
        }

        @Override
        public Long decode(StructuredInput in) throws MalformedDataException {
            return in.readLong64();
        }
    };
    public static final StructuredCodec<Float> FLOAT_CODEC = new StructuredCodec<Float>(){

        @Override
        public void encode(StructuredOutput out, Float value) {
            out.writeFloat(value.floatValue());
        }

        @Override
        public Float decode(StructuredInput in) throws MalformedDataException {
            return Float.valueOf(in.readFloat());
        }
    };
    public static final StructuredCodec<Double> DOUBLE_CODEC = new StructuredCodec<Double>(){

        @Override
        public void encode(StructuredOutput out, Double value) {
            out.writeDouble(value);
        }

        @Override
        public Double decode(StructuredInput in) throws MalformedDataException {
            return in.readDouble();
        }
    };
    public static final StructuredCodec<String> STRING_CODEC = new StructuredCodec<String>(){

        @Override
        public void encode(StructuredOutput out, String value) {
            out.writeString(value);
        }

        @Override
        public String decode(StructuredInput in) throws MalformedDataException {
            return in.readString();
        }
    };
    public static final StructuredCodec<byte[]> BYTES_CODEC = new StructuredCodec<byte[]>(){

        @Override
        public void encode(StructuredOutput out, byte[] value) {
            out.writeBytes(value);
        }

        @Override
        public byte[] decode(StructuredInput in) throws MalformedDataException {
            return in.readBytes();
        }
    };
    public static final StructuredCodec<Void> VOID_CODEC = new StructuredCodec<Void>(){

        @Override
        public Void decode(StructuredInput in) throws MalformedDataException {
            in.readNull();
            return null;
        }

        @Override
        public void encode(StructuredOutput out, Void item) {
            out.writeNull();
        }
    };
    public static final StructuredCodec<Class<?>> CLASS_CODEC = new StructuredCodec<Class<?>>(){

        @Override
        public void encode(StructuredOutput out, Class<?> value) {
            out.writeString(value.getName());
        }

        @Override
        public Class<?> decode(StructuredInput in) throws MalformedDataException {
            try {
                return Class.forName(in.readString());
            }
            catch (ClassNotFoundException e) {
                throw new MalformedDataException((Throwable)e);
            }
        }
    };

    public static <E extends Enum<E>> StructuredCodec<E> ofEnum(final Class<E> enumType) {
        return new StructuredCodec<E>(){

            @Override
            public void encode(StructuredOutput out, E value) {
                out.writeString(((Enum)value).name());
            }

            @Override
            public E decode(StructuredInput in) throws MalformedDataException {
                return Enum.valueOf(enumType, in.readString());
            }
        };
    }

    public static <T> StructuredCodec<Class<? extends T>> ofClass() {
        return CLASS_CODEC;
    }

    static <T> StructuredCodec<T> ofCustomType(Class<T> type) {
        return StructuredCodecs.ofCustomType(type);
    }

    static <T> StructuredCodec<T> ofCustomType(final Type type) {
        return new StructuredCodec<T>(){

            @Override
            public void encode(StructuredOutput out, T item) {
                out.writeCustom(type, item);
            }

            @Override
            public T decode(StructuredInput in) throws MalformedDataException {
                return in.readCustom(type);
            }
        };
    }

    public static <T> StructuredCodec<Optional<T>> ofOptional(final StructuredCodec<T> codec) {
        return new StructuredCodec<Optional<T>>(){

            @Override
            public void encode(StructuredOutput out, Optional<T> item) {
                out.writeNullable(codec, item.orElse(null));
            }

            @Override
            public Optional<T> decode(StructuredInput in) throws MalformedDataException {
                return Optional.ofNullable(in.readNullable(codec));
            }
        };
    }

    public static <T> StructuredCodec<@Nullable T> ofNullable(final StructuredCodec<T> codec) {
        return new StructuredCodec<T>(){

            @Override
            public void encode(StructuredOutput out, T item) {
                out.writeNullable(codec, item);
            }

            @Override
            @Nullable
            public T decode(StructuredInput in) throws MalformedDataException {
                return in.readNullable(codec);
            }
        };
    }

    public static <T, R> StructuredCodec<R> transform(final StructuredCodec<T> codec, final DecoderFunction<T, R> reader, final Function<R, T> writer) {
        return new StructuredCodec<R>(){

            @Override
            public void encode(StructuredOutput out, R value) {
                Object result = writer.apply(value);
                codec.encode(out, result);
            }

            @Override
            public R decode(StructuredInput in) throws MalformedDataException {
                Object result = codec.decode(in);
                try {
                    return reader.decode(result);
                }
                catch (UncheckedException u) {
                    throw (MalformedDataException)u.propagate(MalformedDataException.class);
                }
            }
        };
    }

    public static <T> StructuredCodec<List<T>> ofList(final StructuredCodec<T> valueAdapters) {
        return new StructuredCodec<List<T>>(){

            @Override
            public void encode(StructuredOutput out, List<T> item) {
                out.writeList(valueAdapters, item);
            }

            @Override
            public List<T> decode(StructuredInput in) throws MalformedDataException {
                return in.readList(valueAdapters);
            }
        };
    }

    public static <T> StructuredCodec<Set<T>> ofSet(StructuredCodec<T> codec) {
        return StructuredCodecs.ofList(codec).transform(LinkedHashSet::new, ArrayList::new);
    }

    public static StructuredCodec<Object[]> ofTupleArray(StructuredCodec<?> ... elementDecoders) {
        return StructuredCodecs.ofTupleList(Arrays.asList(elementDecoders)).transform(list -> list.toArray(new Object[0]), Arrays::asList);
    }

    public static StructuredCodec<Object[]> ofTupleArray(List<StructuredCodec<?>> codecs) {
        return StructuredCodecs.ofTupleList(codecs).transform(list -> list.toArray(new Object[0]), Arrays::asList);
    }

    public static <T> StructuredCodec<List<T>> ofTupleList(StructuredCodec<? extends T> ... elementDecoders) {
        return StructuredCodecs.ofTupleList(Arrays.asList(elementDecoders));
    }

    public static <T> StructuredCodec<List<T>> ofTupleList(final List<StructuredCodec<? extends T>> codecs) {
        return new StructuredCodec<List<T>>(){

            @Override
            public List<T> decode(StructuredInput in) throws MalformedDataException {
                return in.readTuple($ -> {
                    ArrayList list = new ArrayList();
                    for (StructuredCodec codec : codecs) {
                        list.add(codec.decode(in));
                    }
                    return list;
                });
            }

            @Override
            public void encode(StructuredOutput out, List<T> list) {
                Checks.checkArgument((list.size() == codecs.size() ? 1 : 0) != 0);
                Iterator it = list.iterator();
                out.writeTuple(() -> {
                    for (StructuredCodec codec : codecs) {
                        codec.encode(out, it.next());
                    }
                });
            }
        };
    }

    public static <K, V> StructuredCodec<Map<K, V>> ofMap(final StructuredCodec<K> codecKey, final StructuredCodec<V> codecValue) {
        return new StructuredCodec<Map<K, V>>(){

            @Override
            public void encode(StructuredOutput out, Map<K, V> map) {
                out.writeMap(codecKey, codecValue, map);
            }

            @Override
            public Map<K, V> decode(StructuredInput in) throws MalformedDataException {
                return in.readMap(codecKey, codecValue);
            }
        };
    }

    public static <T> StructuredCodec<Map<String, T>> ofObjectMap(final Map<String, StructuredCodec<? extends T>> fieldCodecs) {
        return new StructuredCodec<Map<String, T>>(){

            @Override
            public Map<String, T> decode(StructuredInput in) throws MalformedDataException {
                return in.readObject($ -> {
                    LinkedHashMap map = new LinkedHashMap();
                    for (Map.Entry entry : fieldCodecs.entrySet()) {
                        String field = (String)entry.getKey();
                        in.readKey(field);
                        StructuredCodec codec = (StructuredCodec)entry.getValue();
                        map.put(field, codec.decode(in));
                    }
                    return map;
                });
            }

            @Override
            public void encode(StructuredOutput out, Map<String, T> map) {
                out.writeObject(() -> {
                    for (Map.Entry entry : fieldCodecs.entrySet()) {
                        String field = (String)entry.getKey();
                        out.writeKey(field);
                        StructuredCodec codec = (StructuredCodec)entry.getValue();
                        codec.encode(out, map.get(field));
                    }
                });
            }
        };
    }

    public static <T> StructuredCodec<List<T>> concat(StructuredCodec<? extends T> ... elementCodecs) {
        return StructuredCodecs.concat(Arrays.asList(elementCodecs));
    }

    public static <T> StructuredCodec<List<T>> concat(final List<StructuredCodec<? extends T>> elementCodecs) {
        return new StructuredCodec<List<T>>(){

            @Override
            public List<T> decode(StructuredInput in) throws MalformedDataException {
                ArrayList result = new ArrayList(elementCodecs.size());
                for (StructuredCodec elementCodec : elementCodecs) {
                    result.add(elementCodec.decode(in));
                }
                return result;
            }

            @Override
            public void encode(StructuredOutput out, List<T> item) {
                Checks.checkArgument((item.size() == elementCodecs.size() ? 1 : 0) != 0);
                for (int i = 0; i < elementCodecs.size(); ++i) {
                    ((StructuredCodec)elementCodecs.get(i)).encode(out, item.get(i));
                }
            }
        };
    }

    public static <R> StructuredCodec<R> tuple(TupleDecoder0<R> constructor) {
        return StructuredCodecs.ofTupleList(new StructuredCodec[0]).transform(list -> constructor.create(), item -> Collections.emptyList());
    }

    public static <R, T1> StructuredCodec<R> tuple(TupleDecoder1<T1, R> constructor, Function<R, T1> getter1, StructuredCodec<T1> codec1) {
        return StructuredCodecs.ofTupleList(codec1).transform(list -> constructor.create(list.get(0)), item -> Collections.singletonList(getter1.apply(item)));
    }

    public static <R, T1, T2> StructuredCodec<R> tuple(TupleDecoder2<T1, T2, R> constructor, Function<R, T1> getter1, StructuredCodec<T1> codec1, Function<R, T2> getter2, StructuredCodec<T2> codec2) {
        return StructuredCodecs.ofTupleList(codec1, codec2).transform(list -> constructor.create(list.get(0), list.get(1)), item -> Arrays.asList(getter1.apply(item), getter2.apply(item)));
    }

    public static <R, T1, T2, T3> StructuredCodec<R> tuple(TupleDecoder3<T1, T2, T3, R> constructor, Function<R, T1> getter1, StructuredCodec<T1> codec1, Function<R, T2> getter2, StructuredCodec<T2> codec2, Function<R, T3> getter3, StructuredCodec<T3> codec3) {
        return StructuredCodecs.ofTupleList(codec1, codec2, codec3).transform(list -> constructor.create(list.get(0), list.get(1), list.get(2)), item -> Arrays.asList(getter1.apply(item), getter2.apply(item), getter3.apply(item)));
    }

    public static <R, T1, T2, T3, T4> StructuredCodec<R> tuple(TupleDecoder4<T1, T2, T3, T4, R> constructor, Function<R, T1> getter1, StructuredCodec<T1> codec1, Function<R, T2> getter2, StructuredCodec<T2> codec2, Function<R, T3> getter3, StructuredCodec<T3> codec3, Function<R, T4> getter4, StructuredCodec<T4> codec4) {
        return StructuredCodecs.ofTupleList(codec1, codec2, codec3, codec4).transform(list -> constructor.create(list.get(0), list.get(1), list.get(2), list.get(3)), item -> Arrays.asList(getter1.apply(item), getter2.apply(item), getter3.apply(item), getter4.apply(item)));
    }

    public static <R, T1, T2, T3, T4, T5> StructuredCodec<R> tuple(TupleDecoder5<T1, T2, T3, T4, T5, R> constructor, Function<R, T1> getter1, StructuredCodec<T1> codec1, Function<R, T2> getter2, StructuredCodec<T2> codec2, Function<R, T3> getter3, StructuredCodec<T3> codec3, Function<R, T4> getter4, StructuredCodec<T4> codec4, Function<R, T5> getter5, StructuredCodec<T5> codec5) {
        return StructuredCodecs.ofTupleList(codec1, codec2, codec3, codec4, codec5).transform(list -> constructor.create(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4)), item -> Arrays.asList(getter1.apply(item), getter2.apply(item), getter3.apply(item), getter4.apply(item), getter5.apply(item)));
    }

    public static <R, T1, T2, T3, T4, T5, T6> StructuredCodec<R> tuple(TupleDecoder6<T1, T2, T3, T4, T5, T6, R> constructor, Function<R, T1> getter1, StructuredCodec<T1> codec1, Function<R, T2> getter2, StructuredCodec<T2> codec2, Function<R, T3> getter3, StructuredCodec<T3> codec3, Function<R, T4> getter4, StructuredCodec<T4> codec4, Function<R, T5> getter5, StructuredCodec<T5> codec5, Function<R, T6> getter6, StructuredCodec<T6> codec6) {
        return StructuredCodecs.ofTupleList(codec1, codec2, codec3, codec4, codec5, codec6).transform(list -> constructor.create(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5)), item -> Arrays.asList(getter1.apply(item), getter2.apply(item), getter3.apply(item), getter4.apply(item), getter5.apply(item), getter6.apply(item)));
    }

    public static <R> StructuredCodec<R> object(TupleDecoder0<R> constructor) {
        return StructuredCodecs.ofObjectMap(Collections.emptyMap()).transform(map -> constructor.create(), item -> CollectionUtils.map());
    }

    public static <R, T1> StructuredCodec<R> object(TupleDecoder1<T1, R> constructor, String field1, Function<R, T1> getter1, StructuredCodec<T1> codec1) {
        return StructuredCodecs.ofObjectMap(CollectionUtils.map((Object)field1, codec1)).transform(map -> constructor.create(map.get(field1)), item -> CollectionUtils.map((Object)field1, getter1.apply(item)));
    }

    public static <R, T1, T2> StructuredCodec<R> object(TupleDecoder2<T1, T2, R> constructor, String field1, Function<R, T1> getter1, StructuredCodec<T1> codec1, String field2, Function<R, T2> getter2, StructuredCodec<T2> codec2) {
        return StructuredCodecs.ofObjectMap(CollectionUtils.map((Object)field1, codec1, (Object)field2, codec2)).transform(map -> constructor.create(map.get(field1), map.get(field2)), item -> CollectionUtils.map((Object)field1, getter1.apply(item), (Object)field2, getter2.apply(item)));
    }

    public static <R, T1, T2, T3> StructuredCodec<R> object(TupleDecoder3<T1, T2, T3, R> constructor, String field1, Function<R, T1> getter1, StructuredCodec<T1> codec1, String field2, Function<R, T2> getter2, StructuredCodec<T2> codec2, String field3, Function<R, T3> getter3, StructuredCodec<T3> codec3) {
        return StructuredCodecs.ofObjectMap(CollectionUtils.map((Object)field1, codec1, (Object)field2, codec2, (Object)field3, codec3)).transform(map -> constructor.create(map.get(field1), map.get(field2), map.get(field3)), item -> CollectionUtils.map((Object)field1, getter1.apply(item), (Object)field2, getter2.apply(item), (Object)field3, getter3.apply(item)));
    }

    public static <R, T1, T2, T3, T4> StructuredCodec<R> object(TupleDecoder4<T1, T2, T3, T4, R> constructor, String field1, Function<R, T1> getter1, StructuredCodec<T1> codec1, String field2, Function<R, T2> getter2, StructuredCodec<T2> codec2, String field3, Function<R, T3> getter3, StructuredCodec<T3> codec3, String field4, Function<R, T4> getter4, StructuredCodec<T4> codec4) {
        return StructuredCodecs.ofObjectMap(CollectionUtils.map((Object)field1, codec1, (Object)field2, codec2, (Object)field3, codec3, (Object)field4, codec4)).transform(map -> constructor.create(map.get(field1), map.get(field2), map.get(field3), map.get(field4)), item -> CollectionUtils.map((Object)field1, getter1.apply(item), (Object)field2, getter2.apply(item), (Object)field3, getter3.apply(item), (Object)field4, getter4.apply(item)));
    }

    public static <R, T1, T2, T3, T4, T5> StructuredCodec<R> object(TupleDecoder5<T1, T2, T3, T4, T5, R> constructor, String field1, Function<R, T1> getter1, StructuredCodec<T1> codec1, String field2, Function<R, T2> getter2, StructuredCodec<T2> codec2, String field3, Function<R, T3> getter3, StructuredCodec<T3> codec3, String field4, Function<R, T4> getter4, StructuredCodec<T4> codec4, String field5, Function<R, T5> getter5, StructuredCodec<T5> codec5) {
        return StructuredCodecs.ofObjectMap(CollectionUtils.map((Object)field1, codec1, (Object)field2, codec2, (Object)field3, codec3, (Object)field4, codec4, (Object)field5, codec5)).transform(map -> constructor.create(map.get(field1), map.get(field2), map.get(field3), map.get(field4), map.get(field5)), item -> CollectionUtils.map((Object)field1, getter1.apply(item), (Object)field2, getter2.apply(item), (Object)field3, getter3.apply(item), (Object)field4, getter4.apply(item), (Object)field5, getter5.apply(item)));
    }

    public static <R, T1, T2, T3, T4, T5, T6> StructuredCodec<R> object(TupleDecoder6<T1, T2, T3, T4, T5, T6, R> constructor, String field1, Function<R, T1> getter1, StructuredCodec<T1> codec1, String field2, Function<R, T2> getter2, StructuredCodec<T2> codec2, String field3, Function<R, T3> getter3, StructuredCodec<T3> codec3, String field4, Function<R, T4> getter4, StructuredCodec<T4> codec4, String field5, Function<R, T5> getter5, StructuredCodec<T5> codec5, String field6, Function<R, T6> getter6, StructuredCodec<T6> codec6) {
        return StructuredCodecs.ofObjectMap(CollectionUtils.map((Object)field1, codec1, (Object)field2, codec2, (Object)field3, codec3, (Object)field4, codec4, (Object)field5, codec5, (Object)field6, codec6)).transform(map -> constructor.create(map.get(field1), map.get(field2), map.get(field3), map.get(field4), map.get(field5), map.get(field6)), item -> CollectionUtils.map((Object)field1, getter1.apply(item), (Object)field2, getter2.apply(item), (Object)field3, getter3.apply(item), (Object)field4, getter4.apply(item), (Object)field5, getter5.apply(item), (Object)field6, getter6.apply(item)));
    }
}

