/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codec;

import io.activej.codec.StructuredCodecs;
import io.activej.codec.StructuredDecoder;
import io.activej.codec.StructuredEncoder;
import io.activej.codec.StructuredInput;
import io.activej.codec.StructuredOutput;
import io.activej.common.api.DecoderFunction;
import io.activej.common.exception.MalformedDataException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public interface StructuredCodec<T>
extends StructuredEncoder<T>,
StructuredDecoder<T> {
    public static <T> StructuredCodec<T> of(final StructuredDecoder<T> decoder, final StructuredEncoder<T> encoder) {
        return new StructuredCodec<T>(){

            @Override
            public void encode(StructuredOutput out, T item) {
                encoder.encode(out, item);
            }

            @Override
            public T decode(StructuredInput in) throws MalformedDataException {
                return decoder.decode(in);
            }
        };
    }

    public static <T> StructuredCodec<T> ofObject(StructuredDecoder<T> decoder, StructuredEncoder<T> encoder) {
        return StructuredCodec.of(StructuredDecoder.ofObject(decoder), StructuredEncoder.ofObject(encoder));
    }

    public static <T> StructuredCodec<T> ofObject(Supplier<T> supplier) {
        return StructuredCodec.of(StructuredDecoder.ofObject(supplier), StructuredEncoder.ofObject());
    }

    public static <T> StructuredCodec<T> ofTuple(StructuredDecoder<T> decoder, StructuredEncoder<T> encoder) {
        return StructuredCodec.of(StructuredDecoder.ofTuple(decoder), StructuredEncoder.ofTuple(encoder));
    }

    default public StructuredCodec<@Nullable T> nullable() {
        return StructuredCodecs.ofNullable(this);
    }

    default public StructuredCodec<List<T>> ofList() {
        return StructuredCodecs.ofList(this);
    }

    default public <R> StructuredCodec<R> transform(DecoderFunction<T, R> reader, Function<R, T> writer) {
        return StructuredCodecs.transform(this, reader, writer);
    }
}

