package io.aalam.common.serializers;

import io.aalam.common.Serializer;
import io.aalam.common.HttpRequest;
import io.aalam.common.HttpResponse;

/**
An abstract JSON serializer class. The class which inherits this,
needs to implement toJson method
This class will be used in send a serialize JSON data as a response
*/
public abstract class JsonSerializer implements Serializer {
    String contentType = "application/json; charset=UTF-8";

    public void serialize(HttpRequest request, HttpResponse response) {
        byte[] data = this.toJson(request, response);
        response.setContentType(this.contentType);
        response.setContent(data);
    }

    /**
    This method is used to serialize data in JSON format

    @param req The http request for which the data is being serialized
    @param resp The http response object which sends this serialized data.
    */
    public abstract byte[] toJson(HttpRequest req, HttpResponse resp);
}
