package io.aalam.common.serializers;

import io.aalam.common.Serializer;
import io.aalam.common.HttpResponse;
import io.aalam.common.HttpRequest;

/**
An abstract HTML serializer class. The class which inherits this,
needs to implement toJson method.
This class will be used in send a serialize HTML data as a response
*/
public abstract class HtmlSerializer implements Serializer {
    String contentType = "text/html; charset=UTF-8";

    public void serialize(HttpRequest request, HttpResponse response) {
        byte[] data = this.render(request, response);
        response.setContentType(this.contentType);
        response.setContent(data);
    }

    /**
    This method is used to serialize data in HTML format

    @param request The http request for which the data is being serialized
    @param response The http response object which sends this serialized data.
    */
    public abstract byte[] render(HttpRequest request, HttpResponse response);
}
