package io.aalam.common.router;

import io.aalam.common.*;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.util.ArrayList;
import java.lang.Exception;


public class Route {
    Method actionMethod;
    String action;
    Pattern regex;
    Object controller;
    int numParams;
    Permissions permissions;
    boolean gotMethod;

    ArrayList<String> httpMethods;

    private Method _getMethod(int numParams)
        throws java.lang.NoSuchMethodException {
        java.lang.Class cc = controller.getClass();
        switch(numParams) {
            case 0:
                return cc.getMethod(action, HttpRequest.class);
            case 1:
                return cc.getMethod(action, HttpRequest.class, String.class);
            case 2:
                return cc.getMethod(action, HttpRequest.class,
                                    String.class, String.class);
            case 3:
                return cc.getMethod(action, HttpRequest.class, String.class,
                                    String.class, String.class);
            case 4:
                return cc.getMethod(action, HttpRequest.class, String.class,
                                    String.class, String.class, String.class);
            case 5:
                return cc.getMethod(action, HttpRequest.class, String.class,
                                    String.class, String.class, String.class,
                                    String.class);
            case 6:
                return cc.getMethod(action, HttpRequest.class, String.class,
                                    String.class, String.class, String.class,
                                    String.class, String.class);
            case 7:
                return cc.getMethod(action, HttpRequest.class, String.class,
                                    String.class, String.class, String.class,
                                    String.class, String.class, String.class);
            case 8:
                return cc.getMethod(action, HttpRequest.class, String.class,
                                    String.class, String.class, String.class,
                                    String.class, String.class, String.class,
                                    String.class);
            case 9:
                return cc.getMethod(action, HttpRequest.class, String.class,
                                    String.class, String.class, String.class,
                                    String.class, String.class, String.class,
                                    String.class, String.class);
            case 10:
                return cc.getMethod(action, HttpRequest.class, String.class,
                                    String.class, String.class, String.class,
                                    String.class, String.class, String.class,
                                    String.class, String.class, String.class);
        }
        return null;
    }

    private void parseUrl(String url) {
        Pattern p = Pattern.compile("(\\{[^/]+?\\})");
        Matcher m = p.matcher(url);
        while(m.find()) {
            this.numParams++;
        }
        this.regex = Pattern.compile(m.replaceAll("([^/]+?)"));
    }

    public Route(String url, String[] methods, Object controller,
                 String action, Permissions perm) throws Exception {
        this.controller = controller;
        this.action = action;
        this.permissions = perm;
        this.numParams = 0;
        this.parseUrl(url);
        this.httpMethods = new ArrayList<String>();
        for (int index = 0; index < methods.length; index++) {
            httpMethods.add(methods[index].toLowerCase());
        }
        this.gotMethod = false;
    }

    public String[] match(HttpRequest req) {
        String method = req.getMethod().name();

        String path = req.path();
        boolean found = false;
        for (String meth : httpMethods) {
            if (method.toLowerCase().equals(meth)) {
                found = true;
                break;
            }
        }

        if (!found)
            return null;

        Matcher m = this.regex.matcher(path);
        if (!m.matches())
            return null;

        String[] argValues = new String[this.numParams];
        for (int index = 0; index < this.numParams; index++) {
            argValues[index] = m.group(index + 1);
        }

        if (argValues.length != this.numParams) {
            return null;
        }

        return argValues;
    }

    private Object _invoke(HttpRequest req, String[] values)
        throws Exception {
        if (!this.gotMethod) {
            try {
                this.actionMethod = this._getMethod(this.numParams);
                this.gotMethod = true;
            } catch (java.lang.NoSuchMethodException e) {
                throw new Exception("Invalid method '" + action + "' in the controller");
            }
        }
        switch(this.numParams) {
            case 0:
                return actionMethod.invoke(this.controller, req);
            case 1:
                return actionMethod.invoke(this.controller, req, values[0]);
            case 2:
                return actionMethod.invoke(this.controller, req, values[0],
                                     values[1]);
            case 3:
                return actionMethod.invoke(this.controller, req, values[0],
                                     values[1], values[2]);
            case 4:
                return actionMethod.invoke(this.controller, req, values[0],
                                     values[1], values[2], values[3]);
            case 5:
                return actionMethod.invoke(this.controller, req, values[0],
                                     values[1], values[2], values[3],
                                     values[4]);
            case 6:
                return actionMethod.invoke(this.controller, req, values[0],
                                     values[1], values[2], values[3],
                                     values[4], values[5]);
            case 7:
                return actionMethod.invoke(this.controller, req, values[0],
                                     values[1], values[2], values[3],
                                     values[4], values[5], values[6]);
            case 8:
                return actionMethod.invoke(this.controller, req, values[0],
                                     values[1], values[2], values[3],
                                     values[4], values[5], values[6],
                                     values[7]);
            case 9:
                return actionMethod.invoke(this.controller, req, values[0],
                                     values[1], values[2], values[3],
                                     values[4], values[5], values[6],
                                     values[7], values[8]);
            case 10:
                return actionMethod.invoke(this.controller, req, values[0],
                                     values[1], values[2], values[3],
                                     values[4], values[5], values[6],
                                     values[7], values[8], values[9]);
        }
        return null;
    }

    public Object invoke(HttpRequest req, String[] values) throws Exception {
        if (values.length != this.numParams) {
            throw new Exception("Invalid set of values");
        }

        try {
            return this._invoke(req, values);
        } catch (java.lang.IllegalAccessException e) {
            throw new Exception("Method '" + action + "' is not public");
        } catch (java.lang.reflect.InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof HttpException) {
                throw (HttpException)cause;
            } else {
                cause.printStackTrace();
                throw HttpException.internalServerError("");
            }
        }
    }

    public Permissions permissions() {
        return this.permissions;
    }
}
