package io.aalam.common;

import static io.netty.handler.codec.http.HttpResponseStatus.*;
import static io.netty.handler.codec.http.HttpVersion.*;
import io.netty.util.CharsetUtil;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.logging.*;

import org.json.JSONObject;
import org.json.JSONArray;


class InvokeMethodDeserializer {
    private String code;
    private String value;

    public InvokeMethodDeserializer(String code, String value) {
        this.code = code;
        this.value = value;
    }
    public static InvokeMethodDeserializer deserialize(byte[] data) {
        JSONObject obj = new JSONObject(data);
        return new InvokeMethodDeserializer(obj.getString("code"), obj.getString("value"));
    }

    public String value() {
        return this.value;
    }

    public String code() {
        return this.code;
    }
}

public class SystemHandler extends HttpPreProcessor {
    private static String prefix = "/" + Config.appProviderCode + "/" + Config.appCode + "/_/";
    private static final Logger log = Logger.getLogger("java-common");

    private void cleanup(HttpRequest req) {
        Launcher.cleanup();
        HttpServer server = Launcher.server();
        server.closeChannel();
    }

    private void migrateCompleted(HttpRequest req) {
        Launcher.callbacks().migrateCompleted();
    }

    private String invokeMethod(HttpRequest req) {
        String method = req.params().get("method").get(0);

        InvokeMethodDeserializer obj = InvokeMethodDeserializer.deserialize(
            req.content().toString(CharsetUtil.UTF_8).getBytes());

        String[] entry = method.split(":");
        try {
            Class cls = java.lang.Class.forName(entry[0]);
            Object entry_inst = cls.newInstance();
            Method meth = cls.getMethod(entry[1], String.class, String.class);
            return (String)meth.invoke(entry_inst, obj.code(), obj.value());
        } catch (Exception e) {
            return "Unable to invoke validator";
        }
    }

    public Object process(HttpRequest req) {
        System.out.println("SystemHandler executed");
        HttpResponse resp = new HttpResponse(req, HTTP_1_1, OK);
        if (req.path().startsWith(prefix)) {
            log.fine("Handling system url " + req.path());

            String action = req.path().substring(prefix.length());
            if (action.equals("cleanup")) {
                this.cleanup(req);
            } else if (action.equals("migrate_completed")) {
                this.migrateCompleted(req);
            } else if (action.equals("invoke_method")) {
                String msg = this.invokeMethod(req);
                resp.setContent(msg.getBytes());
                resp.setContentType("text/plain");
            } else {
                return new HttpResponse(req, HTTP_1_1, BAD_REQUEST);
            }
            return resp;
        }
        return null;
    }
}
