package io.aalam.common;

import io.netty.channel.ChannelHandler.Sharable;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import static io.netty.handler.codec.http.HttpHeaders.Names.*;
import static io.netty.handler.codec.http.HttpResponseStatus.*;
import static io.netty.handler.codec.http.HttpVersion.*;

import org.apache.commons.codec.binary.Hex;

import java.lang.Exception;
import java.io.InputStream;
import java.net.URI;
import java.net.JarURLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.Path;
import java.nio.file.FileSystems;
import java.nio.file.FileSystem;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.HashMap;

@Sharable
public class StaticsHandler extends HttpPrePostProcessor {
    Class appClass;
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";

    public StaticsHandler() throws Exception {
        super();
        String[] entry = Config.getArg("DEFAULT", "entry_point", "").split(":");
        this.appClass = java.lang.Class.forName(entry[0]);
    }

    public HttpResponse _checkCache(
            HttpRequest request,
            HttpResponse response,
            String resource,
            String file) throws Exception {
        if (file.charAt(0) != '/')
            file = "/" + file;
        if (this.appClass.getResource(file) == null) {
            return null;
        }
        URI uri = this.appClass.getResource(file).toURI();
        String[] array = uri.toString().split("!");

        FileSystem fs;
        try {
            fs = FileSystems.getFileSystem(URI.create(array[0]));
        } catch (java.nio.file.FileSystemNotFoundException e) {
            fs = FileSystems.newFileSystem(URI.create(array[0]),
                                           new HashMap<String, String>());
        }
        Path res = fs.getPath(array[1]);
        long ftimeSeconds = Files.getLastModifiedTime(res).toMillis() / 1000;
        long ifModSinceSeconds = 0;
        String ifModifiedSince = request.headers().get(IF_MODIFIED_SINCE);
        SimpleDateFormat dateFormatter = new SimpleDateFormat(
            HTTP_DATE_FORMAT, Locale.US);
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty()) {
            Date ifModifiedSinceDate = dateFormatter.parse(ifModifiedSince);
            ifModSinceSeconds = ifModifiedSinceDate.getTime() / 1000;
        }
        response.headers().set(
            LAST_MODIFIED, dateFormatter.format(
                new Date(Files.getLastModifiedTime(res).toMillis())));
        if (ifModSinceSeconds != ftimeSeconds) {
            JarURLConnection jarConnection =
                (JarURLConnection)(uri.toURL()).
                openConnection();
            String mime = jarConnection.getContentType();
            if (mime == null)
                mime = "application/octet-stream";
            response.setStatus(OK);
            response.setContent(Files.readAllBytes(res));
            response.setContentType(mime);
        } else {
            response.setStatus(NOT_MODIFIED);
        }
        response.headers().set(CACHE_CONTROL, "no-cache");
        fs.close();
        return response;
    }

    public Object process(HttpRequest req) throws Exception {
        System.out.println("StaticsHandler executed");

        String path = req.path();
        if (Config.staticsUrlRoot.equals("")) {
            return null;
        }
        if (path.startsWith(Config.staticsUrlRoot)) {
            String resource = path.substring(Config.staticsUrlRoot.length());
            return _checkCache(req, new HttpResponse(req, HTTP_1_1, OK), resource, resource);
        }
        return null;
    }
    public Object process(HttpResponse response) throws Exception {
        if (response.statusCode() > 299 ||
            response.getHttpRequest().getStaticUrlResource() == null) {
            return response;
        }

        return _checkCache(response.getHttpRequest(),
            response,
            response.getHttpRequest().getStaticUrlResource(),
            response.getHttpRequest().getStaticFile());
    }
}
