package io.aalam.common;

/**
The data serializer used in general to serialize the response content.
*/
public interface Serializer {
    /**
    This method should set the response data in the response and the
    neccessary modifications in the response headers.
    For example, if this method is used to send a json response, it
    should set the response content, and then modify the content type
    header to application/json

    @param request The request object of the the current request it is
                   processing
    @param response The response object that will be used to send the response
                    to the request

    @see HttpRequest
    @see HttpResponse
    */
    public void serialize(HttpRequest request, HttpResponse response);
}
