package io.aalam.common;

import java.util.Formatter;
import java.util.logging.*;
import java.util.Map;
import java.util.HashMap;

import org.json.JSONObject;
import org.json.JSONArray;

import io.netty.util.CharsetUtil;


class PermissionsResponse {
    String name;
    int id;

    PermissionsResponse(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public static PermissionsResponse deserialize(JSONObject jobj) {
        return new PermissionsResponse(jobj.getString("name"),
                                       jobj.getInt("id"));
    }

    public void updateMap(String provider, String app,
                          String permissionGroup, Map<String, Integer> map) {
        map.put(provider + "/" + app + "/" + permissionGroup +
                "/" + this.name, this.id);
    }
}

/**
Cache of all the permissions identifiers of the application
*/
public class RoleCache {
    static Map<String, Integer> _cache = new HashMap<String, Integer>();
    static final Logger log = Logger.getLogger("java-common");

    /**
    Get the permission identifier with it's name

    @param permission Fully qualified permission name
    @return Integer identifier for the permission
    */
    public static Integer get(String permission) {
        if (_cache.get(permission) != null)
            return _cache.get(permission);

        String[] broken = Permissions.breakPermission(permission);
        Formatter fmt = new Formatter();
        HttpResponse response = Utils.requestLocalServer(
            "GET",
            fmt.format("/aalam/base/permissions/%s/%s/%s",
                       broken[0], broken[1], broken[2]).toString(),
            null);
        if (response.statusCode() == 404) {
            log.warning("Unable to find permissions group " + broken[2]);
            return null;
        }

        if (response.statusCode() != 200) {
            log.warning("Unable to get permission from group " + broken[2] + 
                        ", resp status " + response.statusCode());
            return null;
        }

        JSONArray array = new JSONArray(response.content().
                                        toString(CharsetUtil.UTF_8));
        for (int index = 0; index < array.length(); index++) {
            PermissionsResponse.deserialize(
                array.getJSONObject(index)).updateMap(
                broken[0], broken[1], broken[2], _cache);
        }

        return _cache.get(permission);
    }
}
