package io.aalam.common;

import java.util.logging.*;

import org.json.JSONArray;

/**
This class helps the application to check the authority of the
user over a request resource.
*/
public class Role {
    static final Logger log = Logger.getLogger("java-common");

    /**
    Check if the requesting user is an admin

    @param userEmail The email id of the user requesting a URL
    @return True if the user is admin else False
    */
    public static boolean isUserAdmin(String userEmail) throws Exception {
        return Redis.Client().sismember(
            Redis.baseappRedisifyName("adminusers"), userEmail);
    }

    /**
    Check if the requesting user is an admin

    @param request The request object that the action handler receives
    @return True if the user is admin else False
    */
    public static boolean isUserAdmin(HttpRequest request) throws Exception {
        return isUserAdmin(request.auth().email());
    }

    /**
    Check if the user request a URL has permission

    @param request The request object that the action handler receives
    @param grp The permission group name
    @param name The permission name
    @return True if the user has the permission else False
    */
    public static boolean isClientAuthorized(HttpRequest request, String grp, String name) {
        Integer permId = RoleCache.get(Permissions.framePermission(
            Config.appProviderCode, Config.appCode, grp, name));

        return (request.userPermissions != null) &&
               request.userPermissions.contains(permId);
    }
}
