package io.aalam.common;

import java.lang.Exception;
import java.net.InetSocketAddress;

import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisConnectionPool;
import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.RedisURI;

/**
Class to access the redis instance of this application.

The namespace for every application can be accessed by only that application.
The values in an application's namespace will not collide with other
application's keys.

Some commands like config_get, flushall, etc will not work.
*/
public class Redis {
    static RedisConnection<String,String> conn;

    static {
        RedisURI uri = null;

        Config.newSection("redis");
        String url = Config.getArg("redis", "url",
                                   "unix://:password@/var/run/redis/redis.sock");

        String[] uri_params = url.substring(url.indexOf("://") + 3).split("@");
        String password = uri_params[0].substring(1);
        String host = uri_params[1];
        if (url.startsWith("unix://")) {
            uri = RedisURI.Builder
                     .socket(host)
                     .withPassword(password)
                     .build();
        } else if (url.startsWith("redis://")) {
            if (host.indexOf(":") > 0) {
                String[] host_params = host.split(":");
                uri = RedisURI.Builder
                    .redis(host_params[0], Integer.parseInt(host_params[1]))
                    .withPassword(password)
                    .build();
            } else {
                uri = RedisURI.Builder
                    .redis(host, 6379)
                    .withPassword(password)
                    .build();
            }
        }
        if (uri != null)
            conn = new RedisClient(uri).connect(uri);
    }

    /**
    Return the connection object over which one can issue the redis commands

    @return The redis connection object
    @see RedisConnection
    */
    public static RedisConnection<String, String> Client() {
        return conn;
    }

    /**
    This method is used internal by the framework.
    */
    public static String baseappRedisifyName(String name) {
        return "__common__:" + name;
    }
}
