package io.aalam.common;

import java.lang.reflect.Method;
import java.lang.Exception;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.security.Security;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Launcher {
    static HttpServer httpServer;
    static Callbacks callbacks;
    public static int state;

    private static String getMigrateLockFileName() {
        return HttpServer.WSGI_SOCKET_ROOT + "/" + Config.appProviderCode +
            "/" + Config.appCode + ".migrate.lock";
    }

    static void initCallbacks(int state) throws Exception {
        String[] entry = Config.getArg("DEFAULT", "entry_point", "").split(":");
        if (entry.equals("")) {
            throw new Exception("'entry_point' missing in config file");
        }

        Class cls = java.lang.Class.forName(entry[0]);
        Object entry_inst = cls.newInstance();
        Method meth = cls.getMethod(entry[1], int.class);
        callbacks = (Callbacks)meth.invoke(entry_inst, state);
    }

    public final static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Please provide the configuration file");
            System.exit(-1);
        }
        Config.parse(args[0]);
        Security.addProvider(new BouncyCastleProvider());

        Path configFile = Paths.get(args[0]);
        File migrateLock = new File(getMigrateLockFileName());
        String migrateFrom = System.getenv().get("MIGRATE_FROM");
        if (migrateFrom == null) {
            if (migrateLock.exists()) {
                migrateLock.delete();
                state = Callbacks.STATE_POST_MIGRATE;
            } else {
                state = Callbacks.STATE_STARTED;
            }
        } else {
            state = Callbacks.STATE_MIGRATE;
            if (migrateLock.exists()) {
                /* An upgrade is already happening for this app. */
                System.exit(-1);
            }

            try {
                migrateLock.createNewFile();
                FileWriter fw = new FileWriter(migrateLock);
                PrintWriter printer = new PrintWriter(fw);
                printer.append(new Date().toString());
                printer.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        initCallbacks(state);
        httpServer = new HttpServer();
        if (state != Callbacks.STATE_MIGRATE)
            httpServer.run();
        else {
            System.out.println("Migrating java app");
            callbacks.migrate(migrateFrom);
            System.out.println("Migration completed");
        }
        System.exit(100);
    }

    public static HttpServer server() {
        return httpServer;
    }

    public static Callbacks callbacks() {
        return callbacks;
    }

    public static void cleanup() {
        callbacks.cleanup();
    }
}
