package io.aalam.common;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.spdy.SpdyHttpDecoder;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.DefaultEventExecutorGroup;

public class HttpServerInitializer extends ChannelInitializer<Channel> {
    HooksHandler hooksHandler;
    RouterHandler routerHandler;
    StaticsHandler staticHandler;

    public HttpServerInitializer() throws Exception {
        this.hooksHandler = new HooksHandler();
        this.routerHandler = new RouterHandler();
        this.staticHandler = new StaticsHandler();
    }

    @Override
    public void initChannel(Channel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();

        EventExecutorGroup group = new DefaultEventExecutorGroup(32);
        p.addLast("requestDecoder", new HttpRequestDecoder());
        p.addLast("responseEncoder", new HttpResponseEncoder());
        p.addLast("aggregator", new HttpObjectAggregator(1024 * 1024));
        p.addLast("middlewareEntry", new EntryHandler());
        p.addLast("routerMiddleware", routerHandler);
        p.addLast("authMiddleware", new AuthHandler());
        p.addLast("authorizationMiddleware", new AuthorizationHandler());
        p.addLast("hookPreHandler", hooksHandler);
        p.addLast("systemMiddleware", new SystemHandler());
        p.addLast("staticsPreMiddleware", staticHandler);
        p.addLast("appHandler", new AppHandler());
        p.addLast("staticsPostMiddleware", staticHandler);
        p.addLast("hookPostHandler", hooksHandler);
        p.addLast("middlewareExit", new ExitHandler());
    }
}
