package io.aalam.common;

import java.lang.Exception;

import static io.netty.handler.codec.http.HttpResponseStatus.*;
import io.netty.handler.codec.http.HttpResponseStatus;


/**
The http exception objects are thrown by the action handler when it wishes to
abort the processing when it faces an error.
*/
public class HttpException extends Exception {
    public HttpResponseStatus status;
    public String message;

    /**
    Initialize the Exception with appropriate status code and a message

    @param status Status of the response.
    @param message Message to be present in the response.
    @see HttpResponseStatus
    */
    public HttpException(HttpResponseStatus status, String message) {
        this.status = status;
        this.message = message;
    }

    /**
    Raise to return response with status "404 Not Found" and a custom message
    */
    public static HttpException notFound(String message) {
        return new HttpException(NOT_FOUND, message);
    }

    /**
    Returns an Exception object that returns response with status
    "404 Not Found" and a custom message
    */
    public static HttpException unAuthorized(String message) {
        return new HttpException(UNAUTHORIZED, message);
    }

    /**
    Returns an Exception object that returns response with status
    "403 Forbidden" and a custom message
    */
    public static HttpException forbidden(String message) {
        return new HttpException(FORBIDDEN, message);
    }

    /**
    Returns an Exception object that returns response with status
    "409 Conflict" and a custom message
    */
    public static HttpException conflict(String message) {
        return new HttpException(CONFLICT, message);
    }

    /**
    Returns an Exception object that returns response with status
    "500 Internal Server Error" and a custom message
    */
    public static HttpException internalServerError(String message) {
        return new HttpException(INTERNAL_SERVER_ERROR, message);
    }
}
