package io.aalam.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.CharsetUtil;

import static io.netty.handler.codec.http.HttpHeaders.Names.*;
import static io.netty.handler.codec.http.HttpResponseStatus.*;
import static io.netty.handler.codec.http.HttpVersion.*;

import java.lang.Thread;


public class EntryHandler extends SimpleChannelInboundHandler<Object> {
    private HttpRequest httpRequest;

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
        return;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof io.netty.handler.codec.http.HttpRequest) {
            FullHttpRequest _msg = (FullHttpRequest) msg;
            httpRequest = new HttpRequest(_msg);
            System.out.println(" >>> " + httpRequest.path());
        }

        if (msg instanceof HttpContent) {
            ctx.fireChannelRead(this.httpRequest);
        }
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        FullHttpResponse response = new DefaultFullHttpResponse(HTTP_1_1, CONTINUE);
        ctx.write(response);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}
