package io.aalam.common;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.HashMap;

import org.ini4j.Ini;
import org.ini4j.Profile;

public class Config {
    /**
    The hostname in which this application is running.
    */
    public static String hostName = "localhost";

    /**
    The code of this portal.
    */
    public static String bizCode = "";

    /**
    The absolute path of the directory where this application can use to write
    data that it wants to persist across reboots.
    */
    public static String dataDir = "";

    /**
    Application execution root path. This is where the application libraries
    are all present.
    */
    public static String packageDir = "";

    /**
    The provider code of this application.
    */
    public static String appProviderCode = null;

    /**
    The app code of this application.
    */
    public static String appCode = null;

    /**
    Email id of the owner of this portal.
    */
    public static String adminUser = null;

    /**
    Path to the permissions map containing the application's permissions
    defined in it's pom.xml
    */
    public static String permissionsMap = null;

    /**
    Path to the settings map containing the application's settings items,
    defined in it's pom.xml
    */
    public static String settingsMap = null;

    /**
    Path to the messages map containing the application's message settings
    defined in it's pom.xml
    */
    public static String messagesMap = null;

    /**
    Path to the hooks map containing the application's hook points,
    defined in it's pom.xml
    */
    public static String hooksMap = null;

    /**
    The statics url prefix of the application as defined in it's pom.xml
    */
    public static String staticsUrlRoot = null;

    /**
    Entry point defined by this application in its pom.xml
    */
    public static String entryPoint = null;

    /**
    Path to the RSA private key used while communicating with other internal
    applications.
    */
    public static String privKey = null;

    /**
    Path to the public key of this application.
    */
    public static String pubKey = null;

    /**
    The central server's public key, used to verify the signature of the request
    from aalam central server.
    */
    public static String centralPubKey = null;

    /**
    Apps server's public key, used to verify the signature of the requests from
    aalam apps server
    */
    public static String appsServerPubKey = null;

    /**
    The path to public keys of the users. This will be used to verify the
    signature of any user requests.
    */
    public static String userKeysPath = null;

    /**
    URL to the mysql database in the format
    mysql://username:password@hostname:port/database_name
    */
    public static String mysqlUrl = null;

    /**
    Url to the redis server. This will be of the format
    `unix://:password@/abosulte/path/to/redis/socket.sock`
    */
    public static String redisUrl = null;
    public static Map<String, Profile.Section> sections = new HashMap<String, Profile.Section>();

    private static Ini conf = null;

    /**
    Application will have no use with this method.
    This method is used internally in the framework.
    */
    public static String getArg(String section, String arg, String defaultValue) {
        if (sections.get(section) == null) {
            newSection(section);
        }

        Profile.Section profileSection = sections.get(section);
        if (profileSection == null)
            return defaultValue;

        String val = profileSection.get(arg);
        if (val != null) {
            return val;
        } else {
            return defaultValue;
        }
    }

    /**
    Application will have no use with this method.
    This method is used internally in the framework.
    */
    public static void newSection(String section) {
        Profile.Section sectionObj = conf.get(section);
        sections.put(section, sectionObj);
    }

    /**
    Application will have no use with this method.
    This method is used internally in the framework.
    */
    public static void parse(String fileName) {
        try {
            conf = new Ini(new File(fileName));
            newSection("DEFAULT");
            hostName = getArg("DEFAULT", "hostname", hostName);
            bizCode = getArg("DEFAULT", "bizcode", bizCode);
            dataDir = getArg("DEFAULT", "datadir", dataDir);
            packageDir = getArg("DEFAULT", "package_dir", packageDir);
            appProviderCode = getArg("DEFAULT", "app_provider_code", appProviderCode);
            appCode = getArg("DEFAULT", "app_code", appCode);
            adminUser = getArg("DEFAULT", "admin_user", adminUser);
            permissionsMap = getArg("DEFAULT", "permissions_map", permissionsMap);
            settingsMap = getArg("DEFAULT", "settings_map", settingsMap);
            messagesMap = getArg("DEFAULT", "messages_map", messagesMap);
            hooksMap = getArg("DEFAULT", "hooks_map", hooksMap);
            staticsUrlRoot = getArg("DEFAULT", "statics_url_root", staticsUrlRoot);
            entryPoint = getArg("DEFAULT", "entry_point", entryPoint);
            privKey = getArg("DEFAULT", "privkey", "/etc/aalam/privkey.pem");
            pubKey = getArg("DEFAULT", "pubkey", "/etc/aalam/pubkey.pem");
            centralPubKey = getArg("auth", "central_pubkey", centralPubKey);
            userKeysPath = getArg("auth", "userkeys_path", userKeysPath);
            appsServerPubKey = getArg("auth", "apps_server_pubkey", appsServerPubKey);
            mysqlUrl = getArg("sqlalchemy", "url", mysqlUrl);
            redisUrl = getArg("redis", "url", redisUrl);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
}
