package io.aalam.common;

import io.aalam.common.router.RouteMatch;

import java.util.logging.*;
import java.lang.Exception;
import java.util.Set;
import java.util.HashSet;

import org.json.JSONArray;


public class AuthorizationHandler extends HttpPreProcessor {
    static final Logger log = Logger.getLogger("java-common");

    public Object process(HttpRequest req) throws Exception {
        System.out.println("AuthorizationHandler executed");
        RouteMatch rm = req.routeMatch();
        Permissions urlPerms = (rm != null)?rm.route().permissions():null;
        String userEmail = (req.auth() == null)?"anonymous":req.auth().email;
        boolean isInternalAuth = (req.auth() == null)?false:req.auth().authType.equals("internal");

        try {
            if (Role.isUserAdmin(userEmail)) {
                return null;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return HttpResponse.internalServerError();
        }

        /* aalam/base app is like an admin among apps */
        if (isInternalAuth && req.auth().from.equals("aalam/base")) {
            return null;
        }

        String redis_key = Redis.baseappRedisifyName("permissions-" + userEmail);
        if (!Redis.Client().exists(redis_key)) {
            HttpResponse resp = Utils.requestLocalServer(
                "POST", "/aalam/base/permissions/cache/" + userEmail,
                null);
            if (resp.statusCode() != 200) {
                log.severe("Unable to cache permissions for user " + userEmail +
                           ", resp " + resp.statusCode());
                return HttpResponse.internalServerError();
            }
        }

        Set<String> userPermissions_str = Redis.Client().smembers(redis_key);
        HashSet<Integer> userPermissions = new HashSet<Integer>();

        for (String s: userPermissions_str) {
            userPermissions.add(Integer.parseInt(s));
        }

        req.setUserPermissions(userPermissions);
        if (urlPerms == null) {
            return null;
        }

        if (!urlPerms.check(req)) {
            return HttpResponse.forbidden();
        }
        return null;
    }
}

