package io.aalam.common;

import io.aalam.common.router.*;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import io.netty.buffer.Unpooled;
import static io.netty.handler.codec.http.HttpHeaders.Names.*;
import static io.netty.handler.codec.http.HttpResponseStatus.*;
import static io.netty.handler.codec.http.HttpVersion.*;

import java.lang.Exception;


public class AppHandler extends HttpPreProcessor {
    public Object process(HttpRequest req) throws Exception {
        System.out.println("AppHandler executed");
        RouteMatch rm = req.routeMatch();
        if (rm == null) {
            return HttpResponse.notFound();
        }

        Object obj;
        obj = rm.route().invoke(req, rm.values());

        HttpResponse response = null;
        if (obj == null) {
            response = new HttpResponse(req, HTTP_1_1, OK);
        } else if (obj instanceof HttpResponse) {
            response = (HttpResponse)obj;
        } else {
            if (obj instanceof StatusTuple) {
                StatusTuple _ret = (StatusTuple)obj;
                response = new HttpResponse(req, HTTP_1_1, _ret.status);
                obj = _ret.data;
            } else if (obj instanceof Serializer) {
                if (response == null)
                    response = new HttpResponse(req, HTTP_1_1, OK);
                ((Serializer)obj).serialize(req, response);
            } else {
                throw new Exception("Unable to serialize this message");
            }
        }

        response.setHttpRequest(req);
        return response;
    }

    protected void sendResponse(ChannelHandlerContext ctx, HttpRequest req, Object data) {
        HttpResponse response = (HttpResponse)data;
        ctx.fireChannelRead(response.retain());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof HttpException) {
            HttpException exc = (HttpException)cause;
            HttpResponse response = new HttpResponse(
                null, HTTP_1_1, exc.status,
                Unpooled.copiedBuffer(exc.message, CharsetUtil.UTF_8));
            ctx.write(response);
            return;
        } else {
            cause.printStackTrace();
            ctx.write(new HttpResponse(
                null, HTTP_1_1, INTERNAL_SERVER_ERROR));
            return;
        } 
    }
}
