/*
 * Decompiled with CFR 0.152.
 */
package driveline.transport;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public class TransportConfig {
    int reconnectAttempts;
    Duration pauseBeforeReconnect;
    Duration connectionTimeout;
    Duration readTimeout;

    public static TransportConfig getDefault() {
        return new TransportConfig().withReconnectAttempts(10).withReadTimeout(1L, ChronoUnit.SECONDS).withPauseBeforeReconnectAttempts(100L, ChronoUnit.MILLIS).withConnectionTimeout(400L, ChronoUnit.MILLIS);
    }

    public TransportConfig withReconnectAttempts(int attempts) {
        this.reconnectAttempts = attempts;
        return this;
    }

    public TransportConfig withReadTimeout(long value, TemporalUnit unit) {
        return this.withReadTimeout(Duration.of(value, unit));
    }

    public TransportConfig withReadTimeout(Duration value) {
        this.readTimeout = value;
        return this;
    }

    public TransportConfig withPauseBeforeReconnectAttempts(long value, TemporalUnit unit) {
        return this.withPauseBeforeReconnectAttempts(Duration.of(value, unit));
    }

    public TransportConfig withPauseBeforeReconnectAttempts(Duration value) {
        this.pauseBeforeReconnect = value;
        return this;
    }

    public TransportConfig withConnectionTimeout(long value, TemporalUnit unit) {
        return this.withConnectionTimeout(Duration.of(value, unit));
    }

    public TransportConfig withConnectionTimeout(Duration value) {
        this.connectionTimeout = value;
        return this;
    }
}

