/*
 * Decompiled with CFR 0.152.
 */
package driveline.transport;

import driveline.transport.Transport;
import driveline.transport.TransportConfig;
import driveline.transport.TransportDelegate;
import driveline.transport.TransportException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncTransport
implements Transport,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(SyncTransport.class);
    private URI endpoint;
    private TransportConfig config;
    private TransportDelegate delegate;
    private Socket connection;
    private OutputStream sos;
    private InputStream sis;
    private final Object writeLock = new Object();
    private Queue<byte[]> outputBuffer = new LinkedList<byte[]>();
    private Semaphore writeAvailable = new Semaphore(100);
    private Semaphore writerRunnable = new Semaphore(0);
    private byte[] sendBuffer = new byte[0x110400];
    private byte[] readBuffer = new byte[65536];
    private int readAvail = 0;
    private int readPos = 0;
    private static final String SDK_USER_AGENT;
    private static final byte[] HTTP_HEADER;
    private static final byte[] HTTP_RESP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(URI endpoint, TransportConfig config, TransportDelegate delegate) throws TransportException {
        SyncTransport syncTransport = this;
        synchronized (syncTransport) {
            if (this.endpoint != null) {
                throw new TransportException("Transport already connected");
            }
            this.endpoint = endpoint;
            this.config = config;
            this.delegate = delegate;
            this.connect();
            Thread reader = new Thread(this);
            reader.setName("driveline-reader");
            reader.setDaemon(true);
            reader.start();
            this.startWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        SyncTransport syncTransport = this;
        synchronized (syncTransport) {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connection = null;
            this.endpoint = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] data) {
        this.writeAvailable.acquireUninterruptibly();
        Object object = this.writeLock;
        synchronized (object) {
            this.outputBuffer.add(data);
            this.writeLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInternal(Queue<byte[]> list) {
        block19: {
            try {
                int size = 0;
                for (byte[] msg : list) {
                    SyncTransport syncTransport;
                    this.sendBuffer[size++] = -126;
                    if (msg.length < 126) {
                        this.sendBuffer[size++] = (byte)msg.length;
                        System.arraycopy(msg, 0, this.sendBuffer, size, msg.length);
                        size += msg.length;
                    } else if (msg.length < 65536) {
                        this.sendBuffer[size++] = 126;
                        this.sendBuffer[size++] = (byte)(msg.length >>> 8);
                        this.sendBuffer[size++] = (byte)msg.length;
                        System.arraycopy(msg, 0, this.sendBuffer, size, msg.length);
                        size += msg.length;
                    } else {
                        this.sendBuffer[size++] = 127;
                        this.sendBuffer[size++] = 0;
                        this.sendBuffer[size++] = 0;
                        this.sendBuffer[size++] = 0;
                        this.sendBuffer[size++] = 0;
                        this.sendBuffer[size++] = (byte)(msg.length >>> 24);
                        this.sendBuffer[size++] = (byte)(msg.length >>> 16);
                        this.sendBuffer[size++] = (byte)(msg.length >>> 8);
                        this.sendBuffer[size++] = (byte)msg.length;
                        syncTransport = this;
                        synchronized (syncTransport) {
                            if (this.sos == null) {
                                return;
                            }
                            this.sos.write(this.sendBuffer, 0, size);
                            this.sos.write(msg);
                        }
                        size = 0;
                        continue;
                    }
                    if (size < 0x100000) continue;
                    syncTransport = this;
                    synchronized (syncTransport) {
                        if (this.sos == null) {
                            return;
                        }
                        this.sos.write(this.sendBuffer, 0, size);
                    }
                    size = 0;
                }
                if (size <= 0) break block19;
                SyncTransport syncTransport = this;
                synchronized (syncTransport) {
                    if (this.sos != null) {
                        this.sos.write(this.sendBuffer, 0, size);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void receive(byte[] data) {
        this.delegate.onMessage(data, 0, data.length);
    }

    @Override
    public boolean isActive() {
        return this.connection != null;
    }

    private void startWriter() {
        Thread writer = new Thread(() -> {
            block5: while (true) {
                this.writerRunnable.acquireUninterruptibly();
                while (true) {
                    Queue<byte[]> list;
                    if (this.sos == null) continue block5;
                    try {
                        Object object = this.writeLock;
                        synchronized (object) {
                            while (this.outputBuffer.isEmpty()) {
                                this.writeLock.wait();
                            }
                            list = this.outputBuffer;
                            this.outputBuffer = new LinkedList<byte[]>();
                        }
                    }
                    catch (InterruptedException ignored) {
                        continue;
                    }
                    if (list.isEmpty()) continue;
                    this.writeAvailable.release(list.size());
                    this.sendInternal(list);
                }
                break;
            }
        });
        writer.setName("driveline-writer");
        writer.setDaemon(true);
        writer.start();
    }

    private void connect() throws TransportException {
        int tries = this.config.reconnectAttempts;
        while (tries-- > 0) {
            try {
                this.openConnection();
                InputStream tempSis = this.connection.getInputStream();
                OutputStream tempSos = this.connection.getOutputStream();
                tempSos.write(HTTP_HEADER);
                int pos = this.readFrom(tempSis, HTTP_RESP.length);
                byte[] buf = this.getReadBuffer();
                for (int i = 0; i < HTTP_RESP.length; ++i) {
                    if (buf[pos + i] == HTTP_RESP[i]) continue;
                    throw new IOException("Invalid response from HTTP endpoint");
                }
                int state = 2;
                int limit = 65536;
                while (state < 4 && limit-- > 0) {
                    pos = this.readFrom(tempSis, 1);
                    byte c = this.getReadBuffer()[pos];
                    if (c == 13 && (state & 1) == 0) {
                        ++state;
                        continue;
                    }
                    if (c == 10 && (state & 1) == 1) {
                        ++state;
                        continue;
                    }
                    state = 0;
                }
                if (state < 4) {
                    throw new IOException("Invalid response from HTTP endpoint");
                }
                this.sos = tempSos;
                this.sis = tempSis;
                this.writerRunnable.release();
                return;
            }
            catch (IOException ignored) {
                this.closeConnection();
                try {
                    Thread.sleep(this.config.connectionTimeout.toMillis());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw new TransportException("Unable to connect to remote host");
    }

    private void openConnection() throws IOException {
        int port = this.endpoint.getPort();
        if (port == -1) {
            port = this.endpoint.getScheme().equals("ws") ? 80 : 443;
        }
        this.connection = new Socket(this.endpoint.getHost(), port);
        this.connection.setTcpNoDelay(true);
    }

    private void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.connection = null;
        this.sos = null;
        this.sis = null;
        this.readAvail = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (this.connection == null) {
                try {
                    SyncTransport syncTransport = this;
                    synchronized (syncTransport) {
                        if (this.endpoint == null) {
                            return;
                        }
                        this.connect();
                    }
                    this.delegate.onReconnect();
                }
                catch (TransportException e) {
                    try {
                        Thread.sleep(this.config.pauseBeforeReconnect.toMillis());
                    }
                    catch (InterruptedException interruptedException) {}
                }
                continue;
            }
            try {
                boolean mask;
                int pos = this.readFrom(this.sis, 2);
                byte[] hdr = this.getReadBuffer();
                int op = 0x7F & hdr[pos + 0];
                boolean fin = hdr[pos + 0] < 0;
                int len = 0x7F & hdr[pos + 1];
                boolean bl = mask = hdr[pos + 1] < 0;
                if (mask || !fin) {
                    throw new IOException("WebSocket frame invalid");
                }
                int headerLength = 0;
                if (len == 126) {
                    headerLength = 2;
                } else if (len == 127) {
                    headerLength = 8;
                }
                if (headerLength > 0) {
                    pos = this.readFrom(this.sis, headerLength);
                    hdr = this.getReadBuffer();
                    if (len == 126) {
                        len = (0xFF & hdr[pos + 0]) << 8 | 0xFF & hdr[pos + 1];
                    } else {
                        if ((hdr[pos + 0] | hdr[pos + 1] | hdr[pos + 2] | hdr[pos + 3]) != 0) {
                            throw new IOException("WebSocket message length invalid");
                        }
                        len = (0xFF & hdr[pos + 4]) << 24 | (0xFF & hdr[pos + 5]) << 16 | (0xFF & hdr[pos + 6]) << 8 | 0xFF & hdr[pos + 7];
                    }
                }
                if (len > 125 && (op < 1 || op > 2)) {
                    throw new IOException("WebSocket frame invalid");
                }
                if (len > 0x100000) {
                    throw new IOException("WebSocket frame too big " + len + "> 1MB");
                }
                int offset = this.readFrom(this.sis, len);
                if (op == 1 || op == 2) {
                    this.delegate.onMessage(this.getReadBuffer(), offset, len);
                    continue;
                }
                if (op != 8 && op != 9) continue;
            }
            catch (IOException e) {
                log.info("connection closed");
                SyncTransport syncTransport = this;
                synchronized (syncTransport) {
                    this.closeConnection();
                }
                this.delegate.onDisconnect();
                continue;
            }
            break;
        }
    }

    private byte[] getReadBuffer() {
        return this.readBuffer;
    }

    private int readFrom(InputStream sis, int length) throws IOException {
        int avail;
        if (length <= this.readAvail) {
            int retVal = this.readPos;
            this.readAvail -= length;
            this.readPos += length;
            return retVal;
        }
        if (this.readBuffer.length < length) {
            byte[] newBuf = new byte[length];
            System.arraycopy(this.readBuffer, this.readPos, newBuf, 0, this.readAvail);
            this.readBuffer = newBuf;
            this.readPos = 0;
        }
        if (this.readAvail == 0) {
            this.readPos = 0;
        }
        if ((avail = sis.available()) + this.readAvail > this.readBuffer.length) {
            avail = this.readBuffer.length - this.readAvail;
        } else if (avail + this.readAvail < length) {
            avail = length - this.readAvail;
        }
        if (avail + this.readPos + this.readAvail > this.readBuffer.length) {
            System.arraycopy(this.readBuffer, this.readPos, this.readBuffer, 0, this.readAvail);
            this.readPos = 0;
        }
        int retVal = this.readPos;
        while (avail > 0) {
            int nRead = sis.read(this.readBuffer, this.readPos + this.readAvail, avail);
            if (nRead < 0) {
                throw new IOException("EOF reached");
            }
            this.readAvail += nRead;
            avail -= nRead;
        }
        this.readPos += length;
        this.readAvail -= length;
        return retVal;
    }

    static {
        String version = "invalid";
        try (InputStream input = SyncTransport.class.getClassLoader().getResourceAsStream("driveline-sdk.properties");){
            Properties properties = new Properties();
            properties.load(input);
            version = properties.getProperty("version");
        }
        catch (IOException | NullPointerException e) {
            log.error("cannot load properties", (Throwable)e);
        }
        SDK_USER_AGENT = "driveline/" + version + " java";
        HTTP_HEADER = ("GET /control HTTP/1.1\r\nHost: 1533.io\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Key: dGhlIHNhbXBsZSBub25jZQ==\r\nSec-WebSocket-Version: 13\r\nSec-WebSocket-Protocol: driveline\r\nUser-Agent: " + SDK_USER_AGENT + "\r\n\r\n").getBytes();
        HTTP_RESP = "HTTP/1.1 101 Switching Protocols\r\n".getBytes();
    }
}

