/*
 * Decompiled with CFR 0.152.
 */
package driveline.protocol;

import driveline.cbor.CborException;
import driveline.cbor.decoder.CborBuffer;
import driveline.protocol.DataMessage;
import driveline.protocol.ErrorMessage;
import driveline.protocol.SyncMessage;

public abstract class ServerMessage {
    public final long consumerID;
    private static final String INVALID_SERVER_MESSAGE = "invalid server message";

    ServerMessage(long consumerID) {
        this.consumerID = consumerID;
    }

    public static ServerMessage fromBytes(byte[] b, int offset, int length) throws CborException {
        return ServerMessage.fromBytes(new ServerMessageDecoder(), b, offset, length);
    }

    public static ServerMessage fromBytes(ServerMessageDecoder decoder, byte[] b, int offset, int length) throws CborException {
        decoder.reset(b, offset, length);
        return decoder.getServerMessage();
    }

    public abstract boolean isOK();

    public static final class ServerMessageDecoder
    extends CborBuffer {
        public ServerMessageDecoder() {
        }

        ServerMessageDecoder(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        final ServerMessage getServerMessage() throws CborException {
            if ((0xE0 & this.buf[this.offset]) != 128) {
                throw new CborException(ServerMessage.INVALID_SERVER_MESSAGE);
            }
            int messageCount = this.getVarInt16() - 3;
            if (this.buf[this.offset] == 100 && this.buf[this.offset + 1] == 100) {
                this.offset += 5;
                return this.dataMessageFromBytes(messageCount);
            }
            if (this.buf[this.offset] == 99) {
                byte c = this.buf[this.offset + 1];
                if (c == 101) {
                    this.offset += 4;
                    return this.errorMessageFromBytes();
                }
                if (c == 115) {
                    this.offset += 4;
                    return this.syncMessageFromBytes();
                }
            }
            throw new CborException(ServerMessage.INVALID_SERVER_MESSAGE);
        }

        final DataMessage dataMessageFromBytes(int messageCount) throws CborException {
            int i;
            if ((0xE0 & this.buf[this.offset]) != 0) {
                throw new CborException(ServerMessage.INVALID_SERVER_MESSAGE);
            }
            long consumerId = this.getVarInt64();
            Object messageIds = null;
            if ((0xE0 & this.buf[this.offset]) == 128) {
                int tagCount = this.getVarInt8();
                for (i = 0; i < tagCount; i += 2) {
                    int tagId = this.getVarInt8();
                    if (tagId == 1) {
                        if ((0xE0 & this.buf[this.offset]) != 128) {
                            throw new CborException(ServerMessage.INVALID_SERVER_MESSAGE);
                        }
                        int idCount = this.getVarInt16();
                        messageIds = new byte[idCount][];
                        for (int j = 0; j < idCount; ++j) {
                            messageIds[j] = this.getByteString();
                        }
                        continue;
                    }
                    throw new CborException(ServerMessage.INVALID_SERVER_MESSAGE);
                }
            } else if (this.isBlank()) {
                ++this.offset;
            } else {
                throw new CborException(ServerMessage.INVALID_SERVER_MESSAGE);
            }
            byte[][] messages = new byte[messageCount][];
            for (i = 0; i < messageCount; ++i) {
                if (this.isBlank()) {
                    ++this.offset;
                    messages[i] = null;
                    continue;
                }
                messages[i] = this.getByteString();
            }
            return new DataMessage(consumerId, messages, (byte[][])messageIds);
        }

        final ErrorMessage errorMessageFromBytes() throws CborException {
            if ((0xE0 & this.buf[this.offset]) != 0) {
                throw new CborException(ServerMessage.INVALID_SERVER_MESSAGE);
            }
            long consumerId = this.getVarInt64();
            String message = this.getTextString();
            return new ErrorMessage(consumerId, message);
        }

        final SyncMessage syncMessageFromBytes() throws CborException {
            if ((0xE0 & this.buf[this.offset]) != 0) {
                throw new CborException(ServerMessage.INVALID_SERVER_MESSAGE);
            }
            long consumerId = this.getVarInt64();
            return new SyncMessage(consumerId);
        }

        private boolean isBlank() {
            int current = 0xFF & this.buf[this.offset];
            return current == 246 || current == 247;
        }
    }
}

