/*
 * Decompiled with CFR 0.152.
 */
package driveline.cbor.encoder;

abstract class CborDataItem {
    static final CborDataItem Null = CborDataItem.byteValueItem(246);
    static final CborDataItem Undefined = CborDataItem.byteValueItem(247);
    static final CborDataItem True = CborDataItem.byteValueItem(245);
    static final CborDataItem False = CborDataItem.byteValueItem(244);

    CborDataItem() {
    }

    abstract int encodedSize();

    abstract int encode(byte[] var1, int var2);

    static int encodeTypeAndSize(byte[] buf, int offset, int type, long size) {
        if (size < 24L) {
            buf[offset] = (byte)((long)type | size);
            return 1;
        }
        if (size < 256L) {
            buf[offset] = (byte)(type | 0x18);
            buf[offset + 1] = (byte)size;
            return 2;
        }
        if (size < 65536L) {
            buf[offset] = (byte)(type | 0x19);
            buf[offset + 1] = (byte)(size >>> 8);
            buf[offset + 2] = (byte)(size & 0xFFL);
            return 3;
        }
        if (size < 0x100000000L) {
            buf[offset] = (byte)(type | 0x1A);
            buf[offset + 1] = (byte)(size >>> 24 & 0xFFL);
            buf[offset + 2] = (byte)(size >>> 16 & 0xFFL);
            buf[offset + 3] = (byte)(size >>> 8 & 0xFFL);
            buf[offset + 4] = (byte)(size & 0xFFL);
            return 5;
        }
        buf[offset] = (byte)(type | 0x1B);
        buf[offset + 1] = (byte)(size >>> 56 & 0xFFL);
        buf[offset + 2] = (byte)(size >>> 48 & 0xFFL);
        buf[offset + 3] = (byte)(size >>> 40 & 0xFFL);
        buf[offset + 4] = (byte)(size >>> 32 & 0xFFL);
        buf[offset + 5] = (byte)(size >>> 24 & 0xFFL);
        buf[offset + 6] = (byte)(size >>> 16 & 0xFFL);
        buf[offset + 7] = (byte)(size >>> 8 & 0xFFL);
        buf[offset + 8] = (byte)(size & 0xFFL);
        return 9;
    }

    static int encodedLength(long value) {
        if (value < 24L) {
            return 1;
        }
        if (value < 256L) {
            return 2;
        }
        if (value < 65536L) {
            return 3;
        }
        if (value < 0x100000000L) {
            return 5;
        }
        return 9;
    }

    private static CborDataItem byteValueItem(final int type) {
        return new CborDataItem(){

            @Override
            int encodedSize() {
                return 1;
            }

            @Override
            int encode(byte[] buf, int offset) {
                buf[offset] = (byte)type;
                return 1;
            }
        };
    }
}

