/*
 * Decompiled with CFR 0.152.
 */
package driveline;

import driveline.cbor.encoder.CborEncoder;
import driveline.cbor.encoder.CborSerializable;
import java.util.HashMap;
import java.util.Map;

interface StreamId
extends CborSerializable {
    default public boolean isAlias() {
        return false;
    }

    public static StreamId of(String streamName) {
        return new TextualStreamId(streamName);
    }

    public static StreamId of(int alias) {
        return new NumericStreamId(alias);
    }

    public static final class Factory {
        private final int[] stack;
        private int freeAliases;
        private final Map<Integer, String> aliases;

        Factory(int capacity) {
            if (capacity < 0) {
                throw new IllegalArgumentException("StreamId.Factory must be initialized with a positive number of values");
            }
            this.stack = new int[capacity];
            for (int i = 0; i < capacity; ++i) {
                this.stack[i] = capacity - 1 - i;
            }
            this.aliases = new HashMap<Integer, String>(capacity);
            this.freeAliases = capacity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final StreamId get(String streamName) {
            Map<Integer, String> map = this.aliases;
            synchronized (map) {
                if (this.freeAliases == 0) {
                    return StreamId.of(streamName);
                }
                int id = this.stack[--this.freeAliases];
                this.aliases.put(id, streamName);
                return StreamId.of(id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void release(StreamId streamId) {
            if (streamId.isAlias()) {
                Map<Integer, String> map = this.aliases;
                synchronized (map) {
                    int id = ((NumericStreamId)streamId).streamId;
                    this.aliases.remove(id);
                    this.stack[this.freeAliases++] = id;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Map<Integer, String> getAliases() {
            Map<Integer, String> map = this.aliases;
            synchronized (map) {
                return new HashMap<Integer, String>(this.aliases);
            }
        }

        final int available() {
            return this.freeAliases;
        }
    }

    public static class TextualStreamId
    implements StreamId {
        final String streamId;

        TextualStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public void encode(CborEncoder encoder) {
            encoder.encode(this.streamId);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TextualStreamId) {
                return this.streamId.equals(((TextualStreamId)obj).streamId);
            }
            return false;
        }

        public int hashCode() {
            return this.streamId.hashCode();
        }
    }

    public static class NumericStreamId
    implements StreamId {
        final int streamId;

        NumericStreamId(int streamId) {
            this.streamId = streamId;
        }

        @Override
        public boolean isAlias() {
            return true;
        }

        @Override
        public void encode(CborEncoder encoder) {
            encoder.encode(this.streamId);
        }

        public boolean equals(Object obj) {
            if (obj instanceof NumericStreamId) {
                return this.streamId == ((NumericStreamId)obj).streamId;
            }
            return false;
        }

        public int hashCode() {
            return Integer.hashCode(this.streamId);
        }
    }
}

